root.profile               package:xps               R Documentation

_R_O_O_T _P_r_o_f_i_l_e _P_l_o_t

_D_e_s_c_r_i_p_t_i_o_n:

     Creates a ROOT profile plot, i.e. a plot of parallel coordinates

_U_s_a_g_e:

     root.profile(x, treename = "*", varlist = NULL, as.log = TRUE, globalscale = TRUE, boxes = TRUE, ylim = NULL, canvasname = "ProfilePlot", save.as = "", w = 800, h = 600)

_A_r_g_u_m_e_n_t_s:

       x: S4 object, usually of class 'DataTreeSet' or 'ExprTreeSet'.

treename: name of tree, usually all trees present in 'rootfile' of
          object 'x'.

 varlist: leaf name of tree, usual fInten or fLevel.

  as.log: logical indicating if 'varlist' should be drawn as
          logarithmic data.

globalscale: logical indicating if all axes should be drawn at the same
          scale.

   boxes: logical indicating if box-and-whisker plots should be drawn.

    ylim: size limits c(min,max) of 'varlist'.

canvasname: name of ROOT canvas

 save.as: graphics type for saving canvas, one of ps, eps, pdf,
          jpg, gif, png, tiff

       w: the width of the device in pixels.

       h: the height of the device in pixels.

_D_e_t_a_i_l_s:

     Creates a ROOT profile plot for all trees 'treename="*"' present
     in 'rootfile'. In this  case 'varlist' must be the name of one
     tree leaf only; for 'varlist=NULL' leaf "fInten" will be used for
     class 'DataTreeSet' and leaf "fLevel" will be used for class
     'ExprTreeSet'. If 'treename' is the name of one tree only then
     'varlist' can contain up to all leaves of the tree, separated by
     colons, e.g. 'varlist="fLevel:fStdev"'.

     For 'boxes=TRUE' the profile plot draws box-and-whisker plots and
     can thus be considered the equivalent of the  usual 'boxplot'.

     A ROOT profile plot, i.e. a plot of parallel coordinates, is drawn
     in a TreeViewer, a graphic user interface designed to handle
     'ROOT' trees. You can activate context menus by right-clicking on
     items or inside the right panel.

     The TreeViewer is explained in <URL:
     http://root.cern.ch/root/html/TTreeViewer.html>.

     By selecting menu File->Save->canvasname.xxx you can save the
     figure as e.g. *gif, *.jpg, *.pdf, *.ps or even as C++ macro.

     Alternatively, you can save the plot by setting 'save.as'.
     However, this will close the canvas immediately after opening it.

_N_o_t_e:

     Always select menu item Quit ROOT from menu File to close the
     ROOT tree viewer, otherwise you are in the CINT C/C++ interpreter
     from 'ROOT'. To exit CINT, you need to type .q.

_A_u_t_h_o_r(_s):

     Christian Stratowa

_E_x_a_m_p_l_e_s:

     ## Not run: 
     ## first, load ROOT scheme file and ROOT data file
     scheme.test3 <- root.scheme(paste(.path.package("xps"),"schemes/SchemeTest3.root",sep="/"))
     data.test3 <- root.data(scheme.test3, paste(.path.package("xps"),"rootdata/DataTest3_cel.root",sep="/"))

     root.profile(data.test3)
     ## End(Not run)

