### Name: intensity-methods
### Title: Get/Set Data Values
### Aliases: intensity-methods intensity intensity<-
### Keywords: methods

### ** Examples

## Not run: 
##D ## load ROOT scheme file and ROOT data file
##D scheme.test3 <- root.scheme(paste(.path.package("xps"),"schemes/SchemeTest3.root",sep="/"))
##D data.test3 <- root.data(scheme.test3, paste(.path.package("xps"),"rootdata/DataTest3_cel.root",sep="/"))
##D 
##D ## get intensity values
##D value <- intensity(data.test3)
##D 
##D ## make a copy of your object if you do not want to replace it
##D newdata.test3 <- data.test3
##D 
##D ## replace slot data with value
##D intensity(newdata.test3, "ReplacementData", FALSE) <- value
##D str(newdata.test3)
##D 
##D ## now you can create an ExprTreeSet using the new intensity data
##D data.rma <- rma(newdata.test3,"ReplacementRMA",tmpdir="",background="none",normalize=TRUE,verbose=FALSE)
## End(Not run)



