### Name: express
### Title: Compute expression levels from raw data
### Aliases: express xpsPreprocess-methods xpsPreprocess
### Keywords: manip

### ** Examples

## load existing ROOT scheme file and ROOT data file
scheme.test3 <- root.scheme(paste(.path.package("xps"),"schemes/SchemeTest3.root",sep="/"))
data.test3 <- root.data(scheme.test3, paste(.path.package("xps"),"rootdata/DataTest3_cel.root",sep="/"))

## compute rma with a single call to express()
expr.rma <- express(data.test3,"tmp_Test3Exprs",filedir=getwd(),tmpdir="",update=FALSE,
            bgcorrect.method="rma",bgcorrect.select="none",bgcorrect.option="pmonly:epanechnikov",bgcorrect.params=c(16384),
            normalize.method="quantile",normalize.select="pmonly",normalize.option="transcript:together:none",normalize.logbase="0",normalize.params=c(0.0),
            summarize.method="medianpolish",summarize.select="pmonly",summarize.option="transcript",summarize.logbase="log2",summarize.params=c(10, 0.01, 1.0),
            verbose=FALSE)

## get expression data.frame
expr <- exprs(expr.rma)
head(expr)

## plot expression levels
if (interactive()) {
boxplot(expr.rma)
boxplot(log2(expr[,3:6]))
}

## Not run: 
##D ## examples using Affymetrix human tissue dataset (see also xps/examples/script4exon.R)
##D 
##D ## example - exon array, e.g. HuEx-1_0-st-v2:
##D scmdir <- "/Volumes/GigaDrive/CRAN/Workspaces/Schemes"
##D datdir <- "/Volumes/GigaDrive/CRAN/Workspaces/ROOTData"
##D scheme.exon <- root.scheme(paste(scmdir,"Scheme_HuEx10stv2r2_na25.root",sep="/"))
##D data.exon   <- root.data(scheme.exon, paste(datdir,"HuTissuesExon_cel.root",sep="/"))
##D 
##D workdir <- "/Volumes/GigaDrive/CRAN/Workspaces/Exon/hutissues/exon"
##D expr.rma <- express(data.exon,"HuExonExprs",filedir=workdir,tmpdir="",update=F,
##D             bgcorrect.method="rma",bgcorrect.select="antigenomic",bgcorrect.option="pmonly:epanechnikov",bgcorrect.params=c(16384),
##D             normalize.method="quantile",normalize.select="pmonly",normalize.option="transcript:together:none",normalize.logbase="0",normalize.params=c(0.0),
##D             summarize.method="medianpolish",summarize.select="pmonly",summarize.option="transcript",summarize.logbase="log2",summarize.params=c(10, 0.01, 1.0),
##D             exonlevel="metacore+affx")
## End(Not run)



