delta.plot             package:siggenes             R Documentation

_D_e_l_t_a _P_l_o_t_s

_D_e_s_c_r_i_p_t_i_o_n:

     Generates both a plot of Delta vs. the FDR and a plot of  Delta
     vs. the number of identified genes in a SAM analysis.

_U_s_a_g_e:

       delta.plot(object, delta = NULL, helplines = FALSE)

_A_r_g_u_m_e_n_t_s:

  object: a object of class SAM.

   delta: a vector of values for Delta. If 'NULL', a default set of
          Delta values will be used.

helplines: if 'TRUE', help lines will be drawn in the Delta plots.

_D_e_t_a_i_l_s:

     The Delta plots are a visualization of the table generated by
     'sam' that contains the estimated FDR and the number of identified
     genes for a set of Delta values.

_V_a_l_u_e:

     Two plots in one graphsheet: The plot of Delta vs. FDR and the
     plot of Delta vs. the number of identified genes.

_A_u_t_h_o_r(_s):

     Holger Schwender, holger.schw@gmx.de

_R_e_f_e_r_e_n_c_e_s:

     Tusher, V., Tibshirani, R., and Chu, G. (2001). Significance
     Analysis of Microarrays Applied to the Ionizing Radiation
     Response. _PNAS_, 98, 5116-5121.

_S_e_e _A_l_s_o:

     'SAM-class','sam'

_E_x_a_m_p_l_e_s:

     ## Not run: 
       # Load the package multtest and the data of Golub et al. (1999)
       # contained in multtest.
       library(multtest)
       data(golub)

       # Perform a SAM analysis.
       sam.out<-sam(golub, golub.cl, B=100, rand=123)
       
       # Generate the Delta plots for the default set of Deltas computed by sam.
       delta.plot(sam.out)
       
       # Another way of generating the same plot.
       plot(sam.out)

       # Generate the Delta plots for Delta = 0.2, 0.4, ..., 2.
       plot(sam.out, seq(0.2, 2, 0.2))
     ## End(Not run)

