###################################################
### chunk number 1: initialize
###################################################
options(width=70)


###################################################
### chunk number 2: rtl-init
###################################################
library("humanStemCell")
data(fhesc)
library("genefilter")
filtFhesc <- nsFilter(fhesc)[[1]]
library("limma")
design <- model.matrix(~filtFhesc$Diff) 
hesclim <- lmFit(filtFhesc, design) 
hesceb <- eBayes(hesclim) 
tab <- topTable(hesceb, coef = 2, adjust.method = "BH", n = 7676) 
tab2 <- tab[(tab$logFC > 1) & (tab$adj.P.Val < 0.01),]
affyIDs <- tab2$ID
library("microRNA")
data(hsTargets)
library("hgu133plus2.db")
entrezIDs <- mappedRkeys(hgu133plus2ENTREZID[affyIDs])
library("org.Hs.eg.db")
mappedEntrezIDs <- entrezIDs[entrezIDs %in% mappedkeys(org.Hs.egENSEMBLTRANS)]
ensemblIDs <- mappedRkeys(org.Hs.egENSEMBLTRANS[mappedEntrezIDs])
targetMatches <- match(ensemblIDs, hsTargets$target, 0)
## same as data(targets)
targets <- hsTargets[targetMatches,]


###################################################
### chunk number 3: rtl-miRNA-track
###################################################
head(targets)
library(IRanges)
targetRanges <- IRanges(targets$start, targets$end)
library(rtracklayer)
targetTrack <- GenomicData(targetRanges, 
                           targets[,c("strand", "name", "target")],
                           chrom = paste("chr", targets$chrom, sep = ""), 
                           genome = "hg18")


###################################################
### chunk number 4: feature-data-accessors
###################################################
head(chrom(targetTrack))
head(start(targetTrack))


###################################################
### chunk number 5: sol-1
###################################################
head(strand(targetTrack))
head(width(targetTrack))
data.frame(chrom = chrom(targetTrack), 
           start = start(targetTrack), end = end(targetTrack),
           strand = strand(targetTrack))


###################################################
### chunk number 6: subset-features
###################################################
## get the first 10 targets
first10 <- targetTrack[1:10,]
## get pos strand targets
posTargets <- targetTrack[strand(targetTrack) == "+",]


###################################################
### chunk number 7: subset-chrid
###################################################
chr1Targets <- targetTrack["chr1"]


###################################################
### chunk number 8: sol-2
###################################################
negTargetTrack <- targetTrack[strand(targetTrack) == "-",]


###################################################
### chunk number 9: export eval=FALSE
###################################################
## export(targetTrack, "targets.bed")


###################################################
### chunk number 10: import eval=FALSE
###################################################
## restoredTrack <- import("targets.bed")


###################################################
### chunk number 11: sol-3
###################################################
export(targetTrack, "targets.gff")
targetGff <- import("targets.gff")
targetChar <- export(targetTrack, format = "gff1")


###################################################
### chunk number 12: browserSession eval=FALSE
###################################################
## session <- browserSession("UCSC")


###################################################
### chunk number 13: genomeBrowsers
###################################################
genomeBrowsers()


###################################################
### chunk number 14: layTrack eval=FALSE
###################################################
## track(session, "targets") <- targetTrack


###################################################
### chunk number 15: sol-4 eval=FALSE
###################################################
## session[["target100"]] <- targetTrack[1:100,]


###################################################
### chunk number 16: genomeSegment-track
###################################################
range(chr1Targets)


###################################################
### chunk number 17: sol-5
###################################################
segment <- range(targetTrack[1])
chrom(segment)


###################################################
### chunk number 18: take-subset
###################################################
subTargetTrack <- targetTrack[1,] # get first feature


###################################################
### chunk number 19: view-subset eval=FALSE
###################################################
## view <- browserView(session, range(subTargetTrack) * -10, 
##                     pack = "targets")


###################################################
### chunk number 20: sol-6 eval=FALSE
###################################################
## viewOut <- browserView(session, range(view) * -2)
## viewFull <- browserView(session, full = "targets")


###################################################
### chunk number 21: browseGenome eval=FALSE
###################################################
## browseGenome(targetTrack, 
##              range = range(subTargetTrack) * -10)


###################################################
### chunk number 22: browseGenome-simple eval=FALSE
###################################################
## browseGenome(subTargetTrack)


###################################################
### chunk number 23: get-track-names eval=FALSE
###################################################
## loaded_tracks <- trackNames(session)


###################################################
### chunk number 24: get-track-data eval=FALSE
###################################################
## subTargetTrack <- track(session, "targets")


###################################################
### chunk number 25: get-track-segment eval=FALSE
###################################################
## posTargets <- track(session, "targets", range(chr1Targets))


###################################################
### chunk number 26: sol-7 eval=FALSE
###################################################
## targetSNP <- track(session, "snp128", range(subTargetTrack))
## as.data.frame(targetSNP)
## targetGene <- track(session, "knownGene", range(subTargetTrack))
## as.data.frame(targetGene)


###################################################
### chunk number 27: genomeSegment-view eval=FALSE
###################################################
## segment <- range(view)


###################################################
### chunk number 28: tracks-view eval=FALSE
###################################################
## visible_tracks <- trackNames(view)
## trackNames(view) <- visible_tracks


###################################################
### chunk number 29: track-modes-view eval=FALSE
###################################################
## modes <- ucscTrackModes(view)


###################################################
### chunk number 30: set-track-modes eval=FALSE
###################################################
## modes["targets"]
## modes["targets"] <- "full"
## ucscTrackModes(view) <- modes


###################################################
### chunk number 31: browserViews eval=FALSE
###################################################
## views <- browserViews(session)
## length(views)


###################################################
### chunk number 32: sol-8 eval=FALSE
###################################################
## viewTarget <- track(session, "targets", range(view))
## trackNames(view) <- c("snp128", "knownGene", "targets")
## ucscTrackModes(view)["knownGene"] <- "hide"


###################################################
### chunk number 33: load-snp
###################################################
library(rtracklayer)
data(cpneTrack)


###################################################
### chunk number 34: datavals-accessor
###################################################
head(score(cpneTrack))


###################################################
### chunk number 35: trackData
###################################################
plot(start(cpneTrack), score(cpneTrack))


###################################################
### chunk number 36: layTrack-snp eval=FALSE
###################################################
## session <- browserSession()
## session[["cpne"]] <- cpneTrack


###################################################
### chunk number 37: browserView-snp eval=FALSE
###################################################
## view <- browserView(session, range(cpneTrack[1:5,]), full = "cpne")


###################################################
### chunk number 38: layTrack-snp2 eval=FALSE
###################################################
## track(session, "cpne2", autoScale = FALSE, yLineOnOff = TRUE, 
##       yLineMark = quantile(score(cpneTrack), .25)) <- cpneTrack
## view <- browserView(session, range(cpneTrack[1:5,]), full = "cpne2")


###################################################
### chunk number 39: search-nrsf
###################################################
library(BSgenome.Hsapiens.UCSC.hg18)
nrsfPD <- PDict("TCAGCACCATGGACAG") # TCAGCACC trusted band
nrsfHits <- matchPDict(nrsfPD, Hsapiens[[1]])
countIndex(nrsfHits)


###################################################
### chunk number 40: track-nrsf
###################################################
nrsfTrack <- GenomicData(unlist(nrsfHits), strand="+", chrom="chr1", 
                         genome = "hg18")


###################################################
### chunk number 41: browserView-nrsf eval=FALSE
###################################################
## session <- browseGenome(nrsfTrack, range = range(nrsfTrack[1,]) * -10)


###################################################
### chunk number 42: session-info
###################################################
  sessionInfo()


