### Name: legend.CSP
### Title: Makes a rough legend for the ContourScatterPlot
### Aliases: legend.CSP
### Keywords: hplot

### ** Examples

  if (require(rfcdmin)){
   data.there<-is.element(c("st.1829", "unst.1829", "st.DRT", "unst.DRT"),objects())
   if ( ( sum(data.there) != length(data.there) )){
      ## obtaining the FCS objects from VRC data
      data(VRCmin)
  }

var1<-st.DRT@data[,4]
var2<-st.DRT@data[,5]

col.nm<-colnames(st.DRT@data)

## matrix of counts
count.output1<-make.grid(var1, var2)
mat.counts1<-count.output1$z
if (interactive()){
par(mfrow=c(2,2))

image(mat.counts1,
  main="make.grid: Counts for stimulated",
   xlab=col.nm[4],yaxt="n", xaxt="n",
   ylab=col.nm[5], col=heat.colors(20))

## legend describes the counts in each cell
legend.CSP(mat.counts1, 20, ch.col="heat.colors(n)")

image(mat.counts1,yaxt="n", xaxt="n",
  main="make.grid: Counts for stimulated",
   xlab=col.nm[4],
   ylab=col.nm[5], col=topo.colors(20))

legend.CSP(mat.counts1, 20, ch.col="topo.colors(n)")

}

}



