### Name: WLR.flowcytest
### Title: Weighted Logrank Test for testing the differences between
###   time-to-event, survival curves
### Aliases: WLR.flowcytest WLR
### Keywords: survival univar hplot

### ** Examples


if (require(rfcdmin)){

data.there<-is.element(c("st.1829", "unst.1829", "st.DRT", "unst.DRT"),objects())
if ( ( sum(data.there) != length(data.there) )){
## obtaining the FCS objects from VRC data
data(VRCmin)
}

## This only serves as an example.  Usually the FCS object is
## gated and then subset

## HIV negative individual 1829
  IFN.control<-unst.1829@data[1:2000,4]
  IFN.stimul<-st.1829@data[1:2000,4]


if (interactive()==TRUE){
par(mfrow=c(2,2))
WLR.flowcytest(IFN.control, IFN.stimul,
title="HIV negative individual 1829",
varname="Interferon Gamma")
}
## HIV positive individual DRT
  IFN.control2<-unst.DRT@data[1:2000,4]
  IFN.stimul2<-st.DRT@data[1:2000,4]

if (interactive()==TRUE){
WLR.flowcytest(IFN.control2, IFN.stimul2,
title="HIV positive individual DRT",
varname="Interferon Gamma")
}
## This is an artifical example, but one would expect the
## distributions of the stimulated and control samples
## to be the same in the HIV negative individual 1829
## and to be different in the HIV positive individual DRT
## The test in this example is a bit contrived but
## the bigger picture is achieved.
}



