### Name: vis.res
### Title: Visualize Results
### Aliases: vis.res pr rates fscores show.pr show.roc
### Keywords: misc

### ** Examples

data(syn.data)
data(syn.net)
# Inference
mr <- minet( syn.data, method="mrnet", estimator="mi.empirical" )
ar <- minet( syn.data, method="aracne", estimator="mi.empirical" )
clr<- minet( syn.data, method="clr", estimator="mi.empirical" )
# Validation
mr.tbl <- validate(mr,syn.net)
ar.tbl <- validate(ar,syn.net)
clr.tbl<- validate(clr,syn.net)
# Plot PR-Curves
max(fscores(mr.tbl))
dev <- show.pr(mr.tbl, col="green", type="b")
dev <- show.pr(ar.tbl, device=dev, col="blue", type="b")
show.pr(clr.tbl, device=dev, col="red",type="b")



