getPLM.es              package:metahdep              R Documentation

_g_e_t_P_L_M._e_s

_D_e_s_c_r_i_p_t_i_o_n:

     Calculates effect size estimates for a single study, based on a
     probe-level model, in preparation for a meta-analysis.  It returns
     an 'ES.obj' object containing the result.

_U_s_a_g_e:

     getPLM.es(abatch, trt1, trt2, covariates=NULL, dep.grp=NULL, 
               sub.gn=NULL, bg.norm=TRUE)

_A_r_g_u_m_e_n_t_s:

  abatch: An 'AffyBatch' object containing the data of interest. 

    trt1: A vector (or list of vectors) of array indices for treatment
          level 1 (control).  If more than one test of differential
          expression is to be performed (for multiple covariate levels,
          for example), this should be a list of vectors; each 'trt1' /
          'trt2' vector pair defines a comparison of interest.  

    trt2: A vector (or list of vectors) of array indices for treatment
          level 2 (treatment).  If more than one test of differential
          expression is to be performed (for multiple covariate levels,
          for example), this should be a list of vectors; each 'trt1' /
          'trt2' vector pair defines a comparison of interest.    

covariates: (optional) A 'data.frame' object representing covariate
          differences, if any, among the comparisons defined by 'trt1'
          / 'trt2' vector pairs. This 'data.frame' should have a named
          column for each covariate to be considered in the
          meta-analysis, regardless of whether the covariate takes on
          multiple values in the study represented by the 'abatch'
          argument.  This 'data.frame' must have a row for each
          comparison of interest, as defined by the 'trt1' / 'trt2'
          vector pairs.  Elements of this 'data.frame' should be coded
          numerically. 

 dep.grp: (optional) A single numeric value representing the dependence
          group number assigned to the study. Studies from the same
          research team may be considered hierarchically dependendent
          and share the same value. 

  sub.gn: (optional) A vector of geneNames (probe set ID's); the
          probe-level model will only be fit for these probesets.  If
          NULL (default), all probesets are used. 

 bg.norm: (optional) A logical value specifying whether or not to
          perform background correction and normalization before
          fitting the probe-level model. 

_D_e_t_a_i_l_s:

     For some subset of probesets in a gene expression study, this
     function calculates the effect size estimates based on Bolstad's
     probe-level model (Bolstad 2004), as described in Hu et al.
     (2006). Only two-group comparisons (treatment vs. control, for
     example) are supported. This is done in preparation for a
     meta-analysis of multiple gene expression studies.

_V_a_l_u_e:

     An object of class 'ES.obj'

_A_u_t_h_o_r(_s):

     John R. Stevens, Gabriel Nicholas

_R_e_f_e_r_e_n_c_e_s:

     Bolstad B. M., 2004.  _Low-level Analysis of High-density
     Oligonucleotide Array Data: Background, Normalization and
     Summarization_, PhD dissertation, U.C. Berkeley.

     Hu P., Greenwood C.M.T., and Beyene J. (2006), _Integrative
     Analysis of Gene Expression Data Including an Assessment of
     Pathway Enrichment for Predicting Prostate Cancer_,  _Cancer
     Informatics_ 2006:2 289-300.

     See also the _metahdep_ package vignette.

_E_x_a_m_p_l_e_s:

     ###
     ###  See the metahdep package vignette for a full example 
     ###

