### Name: interval_union
### Title: Genome interval set operations
### Aliases: interval_union interval_union,Genome_intervals-method
###   interval_union,Genome_intervals_stranded-method interval_complement
###   interval_complement,Genome_intervals-method
###   interval_complement,Genome_intervals_stranded-method
###   interval_intersection interval_intersection,Genome_intervals-method
###   interval_intersection,Genome_intervals_stranded-method


### ** Examples

## load toy examples
data(gen_ints)
## content of i object
i
         
## complement
interval_complement(i)
 
## reduced form (non-overlapping interval representation of the covered set)
interval_union(i)

## union
interval_union(i[1:2,], i[1:4,])
 
# map to genome intervals and union again
i.nostrand = as(i,"Genome_intervals")
interval_union(i.nostrand)
 
## intersection with a second object
# print i and j in closed interval notation
close_intervals(i)
close_intervals(j)

# interval_intersection
interval_intersection(i,j)

#interval intersection non-stranded
interval_intersection(i.nostrand, as(j, "Genome_intervals"))



