### Name: distance_to_nearest
### Title: Distance in bases to the closest interval(s)
### Aliases: distance_to_nearest
###   distance_to_nearest,Genome_intervals,Genome_intervals-method
###   distance_to_nearest,Genome_intervals_stranded,Genome_intervals_strand
###   ed-method


### ** Examples

## load toy examples
data(gen_ints)           
 
## i in close_intervals notation
close_intervals(i)
 
## j in close_intervals notation
close_intervals(j)
 
## distances from i to j 
dn = distance_to_nearest(i,j)
dn

## distance == 0 if and only if the interval overlaps another one:
io = interval_overlap(i,j)
if( any( ( sapply(io, length) >0 )  != (!is.na(dn) & dn ==0) ) )
        stop("The property 'distance == 0 if and only if the interval overlaps another one' is not followed for at least one instance.")
 
## distances without strand-specificity
distance_to_nearest( 
                as(i,"Genome_intervals"),
                as(j,"Genome_intervals") 
)       



