### Name: contour-methods
### Title: Contour plots for flow data
### Aliases: contour contour-methods contour,ANY-method
###   contour,flowFrame-method contour,flowSet-method
### Keywords: methods

### ** Examples


data(GvHD)

## simple contour plot
contour(GvHD[[1]])

## overlay with existing plot
plot(GvHD[[1]], c("FSC-H", "SSC-H"))
contour(GvHD[[1]], add=TRUE, col="lightgray", lty=3)

## colored contours
contour(GvHD[[1]], fill="red")
cols <- rainbow(3, alpha=0.1)
contour(GvHD[[1]], fill=cols, col=cols)

## overlay of multiple flowFrames in a flowSet
contour(GvHD[1:3], col=cols, fill=cols)




