### Name: gatherInfo
### Title: Gathers abundance informations from an alignment
### Aliases: gatherInfo
### Keywords: manip

### ** Examples

require(gcspikelite)

# paths and files
gcmsPath<-paste(.find.package("gcspikelite"),"data",sep="/")
cdfFiles<-dir(gcmsPath,"CDF",full=TRUE)
eluFiles<-dir(gcmsPath,"ELU",full=TRUE)

# read data, peak detection results
pd<-peaksDataset(cdfFiles[1:2],mz=seq(50,550),rtrange=c(7.5,8.5))
pd<-addAMDISPeaks(pd,eluFiles[1:2])

# multiple alignment
ma<-multipleAlignment(pd,c(1,1),wn.gap=0.5,wn.D=.05,bw.gap=0.6,bw.D=.2,usePeaks=TRUE,filterMin=1,df=50,verbose=TRUE)

# gather apex intensities
d<-gatherInfo(pd,ma)

# table of retention times
nm<-list(paste("MP",1:length(d),sep=""),c("S1","S2"))
rts<-matrix(unlist(sapply(d,.subset,"rt")),byrow=TRUE,nc=2,dimnames=nm)



