### Name: dyebias.rgplot
### Title: Produce scatterplots of the hybridization, with strongest dye
###   biases highlighted.
### Aliases: dyebias.rgplot dyebias.maplot
### Keywords: hplot misc

### ** Examples


  ## Don't show: 
     options(stringsAsFactors = FALSE)

     library(dyebias)
     library(dyebiasexamples)
     data(data.raw)
     data(data.norm)

     ### obtain estimate for the iGSDBs:
     iGSDBs.estimated <- dyebias.estimate.iGSDBs(data.norm,
                                              is.balanced=TRUE,
                                              verbose=FALSE)

  ### choose the estimators and which spots to correct:
  estimator.subset <- dyebias.umcu.proper.estimators(maInfo(maGnames(data.norm)))

  application.subset <- maW(data.norm) == 1 & dyebias.application.subset(data.raw=data.raw, use.background=TRUE)

  ### do the correction:
  correction <- dyebias.apply.correction(data.norm=data.norm,
                                         iGSDBs = iGSDBs.estimated,
                                         estimator.subset=estimator.subset,
                                         application.subset = application.subset,
                                         verbose=FALSE)

  ## End Don't show                                     

  ## show both an RG-plot and an MA-plot of the uncorrected data and the
  ## corrected data next to each other. 

  slide <- 3                               # or any other other, of course

  layout(matrix(1:4, nrow=2,ncol=2, byrow=TRUE))

  dyebias.rgplot(data=data.norm,
                 slide=slide,
                 iGSDBs=iGSDBs.estimated,   # from dyebias.estimate.iGSDBs
                 main=sprintf("RG-plot, uncorrected, slide %d", slide),
                 output=NULL)

  dyebias.rgplot(data=correction$data.corrected,
                 slide=slide,
                 iGSDBs=iGSDBs.estimated,
                 main=sprintf("RG-plot, corrected, slide %d", slide),
                 output=NULL)

  dyebias.maplot(data=data.norm,
                 slide=slide,
                 iGSDBs=iGSDBs.estimated,
                 main=sprintf("MA-plot, uncorrected, slide %d",slide),
                 output=NULL)

  dyebias.maplot(data=correction$data.corrected,
                 slide=slide,
                 iGSDBs=iGSDBs.estimated,
                 main=sprintf("MA-plot, corrected, slide %d",slide),
                 output=NULL)



