### Name: BASH
### Title: BASH - BeadArray Subversion of Harshlight
### Aliases: BASH
### Keywords: misc

### ** Examples

        data(BLData)
        output <- BASH(BLData,array=1:4)
        boxplot(output$ext) #view spread of extended scores
        for(i in 1:4)
        {
                BLData <- setWeights(BLData, output$wts[[i]], i) #apply BASH weights to BLData
        }

        #diffuse test is stricter
        output <- BASH(BLData, diffsig = 0.00001,array=1)

        #more outliers on the error image are used in the diffuse analysis
        output <- BASH(BLData, diffn = 2,array=1)

        #only perform compact & diffuse analyses (we will only get weights)
        output <- BASH(BLData, extended = FALSE,array=1)

        #attempt to correct for background.
        output <- BASH(BLData, bgcorr = "median",array=1)



