###################################################
### chunk number 1:  eval=FALSE
###################################################
## annotation_HGU133Plus2<-read.csv('HG-U133_Plus_2_annot.csv',colClasses='character')


###################################################
### chunk number 2: 
###################################################
annotationFile<-'HG-U133_Plus_2_annot_part.csv'
dataDirectory<-system.file('data',package='annotationTools')
annotation_HGU133Plus2<-read.csv(paste(dataDirectory,annotationFile,sep='/'),colClasses='character')


###################################################
### chunk number 3: 
###################################################
myPS<-c('117_at','1007_s_at')


###################################################
### chunk number 4: 
###################################################
library(annotationTools)


###################################################
### chunk number 5: 
###################################################
getGENESYMBOL(myPS,annotation_HGU133Plus2)


###################################################
### chunk number 6: 
###################################################
getGENEONTOLOGY(myPS,annotation_HGU133Plus2)


###################################################
### chunk number 7: 
###################################################
getGENEONTOLOGY(myPS,annotation_HGU133Plus2,specifics=2)


###################################################
### chunk number 8: 
###################################################
ls(grep('annotationTools',search()))


###################################################
### chunk number 9: 
###################################################
colnames(annotation_HGU133Plus2)


###################################################
### chunk number 10: 
###################################################
homologeneFile<-'homologene_part.data'
homologene<-read.delim(paste(dataDirectory,homologeneFile,sep='/'),header=FALSE)


###################################################
### chunk number 11: 
###################################################
myGenes<-c(5982,93587)
getHOMOLOG(myGenes,10090,homologene)


###################################################
### chunk number 12: 
###################################################
ps_human<-'1053_at'
geneID_human<-getGENEID(ps_human,annotation_HGU133Plus2)
geneID_mouse<-getHOMOLOG(geneID_human,10090,homologene)
annotationFile<-'Mouse430_2_annot_part.csv'
annotation_Mouse4302<-read.csv(paste(dataDirectory,annotationFile,sep='/'),colClasses='character')
geneID_mouse<-unlist(geneID_mouse)
ps_mouse<-getPROBESET(geneID_mouse,annotation_Mouse4302)
ps_mouse


###################################################
### chunk number 13: 
###################################################
affyOrthologFile<-'HG-U133_Plus_2_ortholog_part.csv'
orthologs_HGU133Plus2<-read.csv(paste(dataDirectory,affyOrthologFile,sep='/'),colClasses='character')


###################################################
### chunk number 14: 
###################################################
getHOMOLOG('1053_at','Mouse430_2',orthologs_HGU133Plus2,cluster=TRUE,clusterCol=1,speciesCol=4,idCol=3)


###################################################
### chunk number 15:  eval=FALSE
###################################################
## orthoTable<-ps2ps(annotation_HGU133Plus2,annotation_Mouse4302,homologene,10090)


###################################################
### chunk number 16:  eval=FALSE
###################################################
## annotation_HGU133Plus2<-read.csv('HG-U133_Plus_2_annot.csv',colClasses='character')
## annotation_Mouse4302<-read.csv('Mouse430_2_annot.csv',colClasses='character')
## homologene<-read.delim('homologene.data',header=F)
## target_species<-10090
## 
## ps_HGU133Plus2<-annotation_HGU133Plus2[,1]
## gid_HGU133Plus2<-getGENEID(ps_HGU133Plus2,annotation_HGU133Plus2)
## length_gid_HGU133Plus2<-sapply(gid_HGU133Plus2,function(x) {length(x)})
## gid_Mouse4302<-getHOMOLOG(unlist(gid_HGU133Plus2),target_species,homologene)
## length_gid_Mouse4302<-sapply(gid_Mouse4302,function(x) {length(x)})
## ps_Mouse4302<-getPROBESET(unlist(gid_Mouse4302),annotation_Mouse4302)
## 
## ps_Mouse4302_1<-compactList(ps_Mouse4302,length_gid_Mouse4302)
## ps_Mouse4302_2<-compactList(ps_Mouse4302_1,length_gid_HGU133Plus2)
## gid_Mouse4302_1<-compactList(gid_Mouse4302,length_gid_HGU133Plus2)


###################################################
### chunk number 17:  eval=FALSE
###################################################
## ps_Mouse4302_2<-lapply(ps_Mouse4302_2,function(x) {unique(x)})
## ps_Mouse4302_2<-lapply(ps_Mouse4302_2,function(x) {if (length(x)>1) na.omit(x) else x})
## gid_Mouse4302_1<-lapply(gid_Mouse4302_1,function(x) {unique(x)})
## gid_Mouse4302_1<-lapply(gid_Mouse4302_1,function(x) {if (length(x)>1) na.omit(x) else x})


###################################################
### chunk number 18:  eval=FALSE
###################################################
## orthoTable<-cbind(ps_HGU133Plus2,listToCharacterVector(gid_HGU133Plus2,sep=','),listToCharacterVector(gid_Mouse4302_1,sep=','),listToCharacterVector(ps_Mouse4302_2,sep=','))
## colnames(orthoTable)<-c('ps_HGU133Plus2','gid_HGU133Plus2','gid_Mouse4302','ps_Mouse4302')
## write.table(orthoTable,file='HGU133Plus2_Mouse4302.txt',sep='\t',col.names=T,row.names=F)


###################################################
### chunk number 19:  eval=FALSE
###################################################
## orthoTable<-ps2ps(annotation_HGU133Plus2,annotation_Mouse4302,homologene,10090)
## write.table(orthoTable,file='HGU133Plus2_Mouse4302.txt',sep='\t',col.names=T,row.names=F)


###################################################
### chunk number 20: 
###################################################
data(orthologs_example)


###################################################
### chunk number 21: 
###################################################
selection<-1:8
ps_mouse<-table_mouse$Probe.Set.ID[selection]
table_mouse[selection,]


###################################################
### chunk number 22: 
###################################################
orthops<-getOrthologousProbesets(ps_mouse,table_human,ortho)
orthops[[1]]


###################################################
### chunk number 23: 
###################################################
table_human_absM<-data.frame(I(table_human[,1]),I(abs(table_human[,2])))


###################################################
### chunk number 24: 
###################################################
orthops_maxAbsM<-getOrthologousProbesets(ps_mouse,table_human_absM,ortho,max,forceProbesetSelection=TRUE)
orthops_maxAbsM[[1]]


###################################################
### chunk number 25: 
###################################################
orthops_maxAbsM_ind<-match(unlist(orthops_maxAbsM[[1]]),table_human[,1])
table_human[orthops_maxAbsM_ind,2]


###################################################
### chunk number 26: 
###################################################
table_human_absT<-data.frame(I(table_human[,1]),I(abs(table_human[,3])))
orthops_maxAbsT<-getOrthologousProbesets(ps_mouse,table_human_absT,ortho,max,forceProbesetSelection=TRUE)
orthops_maxAbsT_ind<-match(unlist(orthops_maxAbsT[[1]]),table_human[,1])
plot(table_mouse[selection,2],table_human[orthops_maxAbsM_ind,2],pch=19,col='gray',cex=1.5,xlab='log fold change in mouse',ylab='log fold change in human')
abline(h=0)
abline(v=0)
abline(0,1)
points(table_mouse[selection,2],table_human[orthops_maxAbsT_ind,2],pch=3,col=1)


###################################################
### chunk number 27: 
###################################################
ps_human<-ortho[match(ps_mouse,ortho[,1]),4]
ps_human


###################################################
### chunk number 28: 
###################################################
ps_human<-lapply(ps_human,function(x){strsplit(x,',')[[1]]})
length_ps_human<-sapply(ps_human,length)
gs_human<-lapply(ps_human,function(x){listToCharacterVector(getGENESYMBOL(x,annot_HGU133A))})
gs_human


###################################################
### chunk number 29: 
###################################################
existing_ps_human<-!is.na(ps_human)


###################################################
### chunk number 30: 
###################################################
LFC_mouse<-table_mouse$M[rep(match(ps_mouse[existing_ps_human],table_mouse$Probe.Set.ID),length_ps_human[existing_ps_human])]


###################################################
### chunk number 31: 
###################################################
LFC_human<-table_human$log2FC.HD.caudate.grade.0.2.vs.controls[match(unlist(ps_human[existing_ps_human]),table_human$Probe.Set.ID)]


###################################################
### chunk number 32:  eval=FALSE
###################################################
## plot(LFC_mouse,LFC_human,col=rep(1:length(ps_human[existing_ps_human]),length_ps_human[existing_ps_human]),pch=16,cex=1.5,xlab='log fold change in mouse',ylab='log fold change in human')
## abline(h=0)
## abline(v=0)
## abline(0,1)
## legend(x=0.25,y=-0.77,legend=lapply(gs_human[existing_ps_human],function(x){paste(unique(x),sep=',')}),text.col=1:length(ps_human[existing_ps_human]))


###################################################
### chunk number 33: 
###################################################
plot(LFC_mouse,LFC_human,col=rep(1:length(ps_human[existing_ps_human]),length_ps_human[existing_ps_human]),pch=16,cex=1.5,xlab='log fold change in mouse',ylab='log fold change in human')
abline(h=0)
abline(v=0)
abline(0,1)
legend(x=0.25,y=-0.77,legend=lapply(gs_human[existing_ps_human],function(x){paste(unique(x),collapse=',')}),text.col=1:length(ps_human[existing_ps_human]))


###################################################
### chunk number 34: 
###################################################
sessionInfo()


