### Name: getGENEID
### Title: Find gene IDs
### Aliases: getGENEID
### Keywords: manip

### ** Examples

##example Affymetrix annotation file and its location
annotationFile<-'HG-U133_Plus_2_annot_part.csv'
dataDirectory<-system.file('data',package='annotationTools')

##load annotation file
annotation<-read.csv(paste(dataDirectory,annotationFile,sep='/'),colClasses='character')

##get gene IDs
myPS<-c('117_at','1007_s_at','1552288_at',NA,'xyz_at')
getGENEID(myPS,annotation)

##track origin of annotation failure for the 3 last probe set IDs
getGENEID(myPS,annotation,diagnose=TRUE)



