### Name: psimi25Hypergraph-class
### Title: Class "psimi25Hypergraph"
### Aliases: psimi25Hypergraph-class hyperedgeNodes edgeLabel revInciMat
###   initialize,Hypergraph-method initialize,psimi25Hypergraph-method
###   show,psimi25Hypergraph-method complexes,psimi25Hypergraph-method
###   edgeLabel,psimi25Hypergraph-method
###   hyperedgeNodes,psimi25Hypergraph-method
###   organismName,psimi25Hypergraph-method
###   numEdges,psimi25Hypergraph-method
###   interactorInfo,psimi25Hypergraph-method
###   hyperedgeNodes,Hypergraph-method revInciMat,matrix-method
### Keywords: classes

### ** Examples

xmlDir <- system.file("/extdata/psi25files",package="RpsiXML")
intactComplexxml <- file.path(xmlDir,"intact_complexSample.xml")
pc1 <- buildPCHypergraph(intactComplexxml, INTACT.PSIMI25)

## print number of proteins and complexes (edges)
numNodes(pc1)
## the same as numInteractors(pc1)
numEdges(pc1)

## print proteins (nodes)
nodes(pc1)[1:3]

## print complex names
edgeLabel(pc1)[1:3]

## print complexes (not so informative with 'hyperedges')
hyperedges(pc1)[1:3]
## better with 'complexes' or 'hyperedgeNodes'
complexes(pc1)[1:3]

## get interactor detailed information
interactors(pc1)[[1]]



