### Name: plotErrorsFoldTwoLayerCV-methods
### Title: plotErrorsFoldTwoLayerCV Method to plot the error rate of a
###   two-layer Cross-validation
### Aliases: plotErrorsFoldTwoLayerCV plotErrorsFoldTwoLayerCV-methods
###   plotErrorsFoldTwoLayerCV,assessment-method
### Keywords: methods

### ** Examples

data('vV70genesDataset')

expeOfInterest <- new("assessment", dataset=vV70genes,
                                   noFolds1stLayer=3,
                                   noFolds2ndLayer=2,
                                   classifierName="svm",
                                   typeFoldCreation="original",
                                   svmKernel="linear",
                                   noOfRepeat=10,
                                   featureSelectionOptions=new("geneSubsets", optionValues=c(1,2,3,4,5,6)))

expeOfInterest <- runTwoLayerExtCV(expeOfInterest)

plotErrorsFoldTwoLayerCV(expeOfInterest)




