### Name: computeSlidingT
### Title: Function to compute sliding T statistics on a tiling expression
###   set
### Aliases: computeSlidingT
### Keywords: manip

### ** Examples

 exDir <- system.file("exData",package="Ringo")
  load(file.path(exDir,"exampleProbeAnno.rda"))
  load(file.path(exDir,"exampleX.rda"))
  tX <- computeSlidingT(exampleX, probeAnno=exProbeAnno,
             allChr=c("9"), winHalfSize=400)
  sampleNames(tX) <- "t-Stat_Suz12vsTotal"
  if (interactive()){
    par(mfrow=c(1,1))
    chipAlongChrom(exampleX, chrom="9", xlim=c(34318000,34321000), ylim=c(-2,8.5), probeAnno=exProbeAnno, gff=exGFF)
    chipAlongChrom(tX, chrom="9", xlim=c(34318000,34321000),
probeAnno=exProbeAnno, itype="l", ilwd=4, paletteName="Spectral",
add=TRUE)
  }



