### Name: crossBuilder_DB
### Title: Build Data Packages for Protein ID Mapping
### Aliases: crossBuilder_DB fasta2list idBlast


### ** Examples

# Set path, version and author for the package.
pkgPath <- tempdir()
version <- "1.0.0"
author <- list()
author[["authors"]] <- "Hong Li"
author[["maintainer"]] <- "Hong Li <sysptm@gmail.com>"

# Set parameters for sequence similarity.
blast <- c("blastp", "10.0", "BLOSUM62", "0", "-1", "-1", "T", "F")
names(blast) <- c("p","e","M","W","G","E","U","F")
match <- c(0.00001, 0.95, 0.95)
names(match) <- c("e","c","i")

## It may take a long time to parse database and build R package.
# Build annotation data packages "org.Hs.cross" for id mapping of three major 
# protein sequence databases.
if(interactive()){
    crossBuilder_DB(src=c("sp","ipi","gi"), organism="Homo sapiens", 
                    blast, match, 
                    prefix="org.Hs.cross", pkgPath, version, author)
}



