### Name: translateKEGGgraph
### Title: Tranlate the KEGG graph from being indexed by KEGGID to another
###   identifer
### Aliases: translateKEGGgraph


### ** Examples

sfile <- system.file("extdata/hsa04010.xml",package="KEGGgraph")
gR <- parseKGML2Graph(sfile,expandGenes=TRUE)

subG <- subKEGGgraph(c("hsa:1848","hsa:1432","hsa:2002","hsa:8986"),gR)
symbols <- c("DUSP6","MAPK14","ELK1","RPS6KA4")
sub2G <- translateKEGGgraph(subG, symbols)
sub2G
nodes(sub2G)

if(require(Rgraphviz) & interactive()) {
plot(sub2G, "neato")
}



