### Name: Sequence-class
### Title: Sequence objects
### Aliases: class:Sequence Sequence-class Sequence subseq subseq<-
###   subseq,vector-method subseq,Sequence-method subseq<-,ANY-method
###   rep,Sequence-method [<-,Sequence-method !=,Sequence,Sequence-method
###   class:XSequence XSequence-class XSequence length,XSequence-method
###   subseq,XSequence-method as.numeric,XSequence-method
###   show,XSequence-method class:XRaw XRaw-class XRaw
###   coerce,raw,XRaw-method coerce,raw,XSequence-method
###   coerce,numeric,XRaw-method as.raw,XRaw-method as.integer,XRaw-method
###   as.vector,XRaw,missing-method [,XRaw-method c,XRaw-method
###   class:XInteger XInteger-class XInteger coerce,numeric,XInteger-method
###   coerce,integer,XSequence-method as.integer,XInteger-method
###   as.vector,XInteger,missing-method [,XInteger-method
###   ==,XInteger,XInteger-method class:XNumeric XNumeric-class XNumeric
###   coerce,numeric,XNumeric-method coerce,numeric,XSequence-method
###   as.numeric,XNumeric-method as.vector,XNumeric,missing-method
###   [,XNumeric-method show,XNumeric-method ==,XNumeric,XNumeric-method
###   class:XRle XRle-class XRle length,XRle-method rep,XRle-method
###   reverse,XRle-method ==,XRle,XRle-method [,XRle-method
###   subseq,XRle-method class:XRleInteger XRleInteger-class XRleInteger
###   Arith,integer,XRleInteger-method Arith,XRleInteger,integer-method
###   Arith,XRleInteger,XRleInteger-method as.integer,XRleInteger-method
###   as.vector,XRleInteger,missing-method
###   coerce,integer,XRleInteger-method show,XRleInteger-method
### Keywords: methods classes

### ** Examples

  ## ---------------------------------------------------------------------
  ## A. XRaw OBJECTS
  ## ---------------------------------------------------------------------

  x1 <- XRaw(4)  # values are not initialized
  x1
  x2 <- as(c(255, 255, 199), "XRaw")
  x2
  y <- c(x1, x2, NULL, x1)  # NULLs are ignored
  y
  subseq(y, start=-4)
  subseq(y, start=-4) <- x2
  y

  ## ---------------------------------------------------------------------
  ## B. XInteger OBJECTS
  ## ---------------------------------------------------------------------

  x3 <- XInteger(12, val=c(-1:10))
  x3
  length(x3)

  ## Subsetting
  x4 <- XInteger(99999, val=sample(99, 99999, replace=TRUE) - 50)
  x4
  subseq(x4, start=10)
  subseq(x4, start=-10)
  subseq(x4, start=-20, end=-10)
  subseq(x4, start=10, width=5)
  subseq(x4, end=10, width=5)
  subseq(x4, end=10, width=0)

  x3[length(x3):1]
  x3[length(x3):1, drop=FALSE]

  x5 <- LETTERS
  subseq(x5, 8, 11) <- x5[11:8]  # swap 8<->11 and 9<->10 elements
  subseq(x5, start=1, width=0) <- c("xx", "yyy")  # insert 2 elements at the beginning
  subseq(x5, end=-1, width=0) <- letters[1:3]  # insert 3 elements at the end
  subseq(x5, end=-4, width=5) <- NULL  # remove 5 elements before the just added ones



