### Name: RangesList-class
### Title: List of Ranges
### Aliases: RangesList-class RangesList end,RangesList-method
###   width,RangesList-method start,RangesList-method space
###   space,RangesList-method universe,RangesList-method
###   universe<-,RangesList-method universe universe<- [,RangesList-method
###   as.data.frame,RangesList-method coerce,RangesList,IRangesList-method
###   coerce,RangesList,RangedData-method Ops,RangesList,ANY-method
###   show,RangesList-method split,Ranges-method
### Keywords: methods classes

### ** Examples

  range1 <- IRanges(start=c(1,2,3), end=c(5,2,8))
  range2 <- IRanges(start=c(15,45,20,1), end=c(15,100,80,5))
  named <- RangesList(one = range1, two = range2)
  length(named) # 2
  start(named) # same as start(c(range1, range2))
  names(named) # "one" and "two"
  named[[1]] # range1
  unnamed <- RangesList(range1, range2)
  names(unnamed) # NULL

  # subset by RangesList
  range1 <- IRanges(start=c(1,2,3), end=c(5,2,8))
  range2 <- IRanges(start=c(1,15,20,45), end=c(5,15,100,80))
  collection <- RangesList(one = range1, range2)
  collection[RangesList()] # empty elements
  collection[RangesList(IRanges(4, 6), IRanges(50, 70))]
  collection[RangesList(IRanges(50, 70), one=IRanges(4, 6))]

  # same as list(range1, range2)
  as.list(RangesList(range1, range2))

  # coerce to data.frame
  as.data.frame(named)

  # set the universe
  universe(named) <- "hg18"
  universe(named)
  RangesList(range1, range2, universe = "hg18")

  ## zoom in 2X
  collection * 2



