### Name: gsMMD2.default
### Title: Gene selection based on a mixture of marginal distributions
### Aliases: gsMMD2.default
### Keywords: classif

### ** Examples


  library(ALL)
  data(ALL)
  eSet1 <- ALL[1:100, ALL$BT == "B3" | ALL$BT == "T2"]
  mat <- exprs(eSet1)
  
  mem.str <- as.character(eSet1$BT)
  nSubjects <- length(mem.str)
  memSubjects <- rep(0, nSubjects)
  # B3 coded as 0, T2 coded as 1
  memSubjects[mem.str == "T2"] <- 1
 
  myWilcox <-
  function(x, memSubjects, alpha = 0.05)
  {
    xc <- x[memSubjects == 1]
    xn <- x[memSubjects == 0]
  
    m <- sum(memSubjects == 1)
    res <- wilcox.test(x = xc, y = xn, conf.level = 1 - alpha)
    res2 <- c(res$p.value, res$statistic - m * (m + 1) / 2)
    names(res2) <- c("p.value", "statistic")
  
    return(res2)
  }
  
  tmp <- t(apply(mat, 1, myWilcox, memSubjects = memSubjects))
  colnames(tmp) <- c("p.value", "statistic")
  memIni <- rep(2, nrow(mat))
  memIni[tmp[, 1] < 0.05 & tmp[, 2] > 0] <- 1
  memIni[tmp[, 1] < 0.05 & tmp[,2] < 0] <- 3
  
  cat("initial gene cluster size>>\n"); print(table(memIni)); cat("\n");
  
  obj.gsMMD <- gsMMD2.default(mat, memSubjects, memIni = memIni,
          transformFlag = TRUE, transformMethod = "boxcox", scaleFlag = TRUE)
  round(obj.gsMMD$para, 3)




