### Name: filter2
### Title: 2D Convolution Filter
### Aliases: filter2


### ** Examples

  x = readImage(system.file("images", "lena-color.png", package="EBImage"))
  if (interactive()) display(x, title='Lena')

  ## Low-pass disc-shaped filter
  f = makeBrush(21, shape='disc', step=FALSE)
  if (interactive()) display(f, title='Disc filter')
  f = f/sum(f)
  y = filter2(x, f)
  if (interactive()) display(y, title='Filtered lena')

  ## High-pass Laplacian filter
  la = matrix(1, nc=3, nr=3)
  la[2,2] = -8
  y = filter2(x, la)
  if (interactive()) display(y, title='Filtered lena')



