### Name: display
### Title: Interactive image display
### Aliases: display animate


### ** Examples

   ## single image
   lena = readImage(system.file("images", "lena-color.png", package="EBImage"))
   if (interactive()) display(lena)

   ## animated threshold
   x = readImage(system.file("images", "lena-color.png", package="EBImage"))
   x = resize(x, 128, 128)
   xt = list()
   for (t in seq(0.1, 5, len=9)) xt=c(xt, list(blur(x, s=t)))
   xt = combine(xt)
   if (interactive()) display(xt, title='Blurred Lenas')



