### Name: reverseSeq
### Title: Reverse Sequence
### Aliases: reverseSeq revcompDNA revcompRNA
### Keywords: manip

### ** Examples

 w <-  c("hey there", "you silly fool")
 if (interactive()) {
   reverseSeq(w)  # deprecated (inefficient on large vectors)
 }
 reverse(BStringSet(w))  # more efficient

 w <- "able was I ere I saw Elba"
 if (interactive()) {
   reverseSeq(w)  # deprecated (inefficient on large vectors)
 }
 reverse(BStringSet(w))  # more efficient

 rna1 <- "UGCA"
 if (interactive()) {
   revcompRNA(rna1)  # deprecated (inefficient on large vectors)
 }
 reverseComplement(RNAString(rna1))  # more efficient

 dna1 <- "TGCA"
 if (interactive()) {
   revcompDNA(dna1)  # deprecated (inefficient on large vectors)
 }
 reverseComplement(DNAString(dna1))  # more efficient

 ## Comparing efficiencies:
 if (interactive()) {
   library(hgu95av2probe)
   system.time(y1 <- reverseSeq(hgu95av2probe$sequence))
   x <- DNAStringSet(hgu95av2probe$sequence)
   system.time(y2 <- reverse(x))

   system.time(y3 <- revcompDNA(hgu95av2probe$sequence))
   system.time(y4 <- reverseComplement(x))
 }



