### Name: replaceLetterAt
### Title: Replacing letters in a sequence (or set of sequences) at some
###   specified locations
### Aliases: replaceLetterAt replaceLetterAt,DNAString-method
###   replaceLetterAt,DNAStringSet-method .inplaceReplaceLetterAt
###   replaceLetterAtLoc
### Keywords: utilities manip

### ** Examples

  ## Replace letters of a DNAString object:
  replaceLetterAt(DNAString("AAMAA"), c(5, 1, 3, 1), "TYNC")
  replaceLetterAt(DNAString("AAMAA"), c(5, 1, 3, 1), "TYNC", if.not.extending="merge")

  ## Replace letters of a DNAStringSet object (sorry for the totally
  ## artificial example with absolutely no biological meaning):
  library(drosophila2probe)
  probes <- DNAStringSet(drosophila2probe$sequence)
  at <- matrix(c(TRUE, TRUE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE),
               nrow=length(probes), ncol=width(probes)[1],
               byrow=TRUE)
  letter_subject <- DNAString(paste(rep.int("-", width(probes)[1]), collapse=""))
  letter <- as(Views(letter_subject, start=1, end=rowSums(at)), "XStringSet")
  replaceLetterAt(probes, at, letter)



