### Name: letter
### Title: Subsetting a string
### Aliases: letter letter,character-method letter,XString-method
###   letter,XStringViews-method letter,MaskedXString-method
### Keywords: methods

### ** Examples

  x <- c("abcd", "ABC")
  i <- c(3, 1, 1, 2, 1)

  ## With a character vector:
  letter(x[1], 3:1)
  letter(x, 3)
  letter(x, i)
  #letter(x, 4)             # Error!

  ## With a BString object:
  letter(BString(x[1]), i)  # returns a character vector
  BString(x[1])[i]          # returns a BString object

  ## With an XStringViews object:
  x2 <- XStringViews(x, "BString")
  letter(x2, i)



