### Name: XStringSet-class
### Title: BStringSet, DNAStringSet, RNAStringSet and AAStringSet objects
### Aliases: class:XStringSet XStringSet-class XStringSet class:BStringSet
###   BStringSet-class BStringSet class:DNAStringSet DNAStringSet-class
###   DNAStringSet class:RNAStringSet RNAStringSet-class RNAStringSet
###   class:AAStringSet AAStringSet-class AAStringSet
###   length,XStringSet-method width,character-method
###   width,XStringSet-method nchar,XStringSet-method
###   names,XStringSet-method names<-,XStringSet-method
###   narrow,character-method narrow,XStringSet-method
###   subseq,character-method subseq,XStringSet-method
###   threebands,character-method threebands,XStringSet-method
###   subseq<-,character-method subseq<-,XStringSet-method
###   xsbasetype,XStringSet-method xsbasetype<-,XStringSet-method
###   coerce,XStringSet,BStringSet-method
###   coerce,XStringSet,DNAStringSet-method
###   coerce,XStringSet,RNAStringSet-method
###   coerce,XStringSet,AAStringSet-method
###   coerce,character,BStringSet-method
###   coerce,character,DNAStringSet-method
###   coerce,character,RNAStringSet-method
###   coerce,character,AAStringSet-method
###   coerce,character,XStringSet-method coerce,XString,BStringSet-method
###   coerce,XString,DNAStringSet-method coerce,XString,RNAStringSet-method
###   coerce,XString,AAStringSet-method coerce,XString,XStringSet-method
###   show,XStringSet-method [,XStringSet-method rep,XStringSet-method
###   [[,XStringSet-method [[<-,XStringSet-method
###   append,XStringSet,XStringSet-method order,XStringSet-method
###   sort,XStringSet-method rank,XStringSet-method
###   duplicated,XStringSet-method unique,XStringSet-method
###   union,XStringSet,XStringSet-method
###   intersect,XStringSet,XStringSet-method
###   setdiff,XStringSet,XStringSet-method
###   setequal,XStringSet,XStringSet-method
###   %in%,character,XStringSet-method %in%,XString,XStringSet-method
###   %in%,XStringSet,XStringSet-method match,character,XStringSet-method
###   match,XString,XStringSet-method match,XStringSet,XStringSet-method
###   unlist,XStringSet-method as.character,XStringSet-method
###   toString,XStringSet-method as.matrix,XStringSet-method
### Keywords: methods classes

### ** Examples

  ## ---------------------------------------------------------------------
  ## A. USING THE XStringSet CONSTRUCTORS ON A CHARACTER VECTOR
  ## ---------------------------------------------------------------------
  ## Note that there is no XStringSet() constructor, but an XStringSet
  ## family of constructors: BStringSet(), DNAStringSet(), RNAStringSet(),
  ## etc...
  x0 <- c("#CTC-NACCAGTAT", "#TTGA", "TACCTAGAG")
  width(x0)
  x1 <- BStringSet(x0)
  x1

  ## 3 equivalent ways to obtain the same BStringSet object:
  BStringSet(x0, start=4, end=-3)
  subseq(x1, start=4, end=-3)
  BStringSet(subseq(x0, start=4, end=-3))

  dna0 <- DNAStringSet(x0, start=4, end=-3)
  dna0
  names(dna0)
  names(dna0)[2] <- "seqB"
  dna0

  ## ---------------------------------------------------------------------
  ## B. USING THE XStringSet CONSTRUCTORS ON AN XStringSet OBJECT
  ## ---------------------------------------------------------------------
  library(drosophila2probe)
  probes <- DNAStringSet(drosophila2probe$sequence)
  probes

  RNAStringSet(probes, start=2, end=-5)  # does NOT copy the sequence data!

  ## ---------------------------------------------------------------------
  ## C. USING subseq() ON AN XStringSet OBJECT
  ## ---------------------------------------------------------------------
  subseq(probes, start=2, end=-5)

  subseq(probes, start=13, end=13) <- "N"
  probes

  ## Add/remove a prefix:
  subseq(probes, start=1, end=0) <- "--"
  probes
  subseq(probes, end=2) <- ""
  probes

  ## Do more complicated things:
  subseq(probes, start=4:7, end=7) <- c("YYYY", "YYY", "YY", "Y")
  subseq(probes, start=4, end=6) <- subseq(probes, start=-2:-5)
  probes

  ## ---------------------------------------------------------------------
  ## D. UNLISTING AN XStringSet OBJECT
  ## ---------------------------------------------------------------------
  library(drosophila2probe)
  probes <- DNAStringSet(drosophila2probe$sequence)
  unlist(probes)  



