### Name: AssociateWithGenes
### Title: Associates a vector of probe positions with the nearest input
###   transcription start site.
### Aliases: AssociateWithGenes
### Keywords: data

### ** Examples

data(KnownGenes)

## Calculate the gene nearest to each probe in Einter data frame.
NearestGenes <- AssociateWithGenes(KG[,1], KG[,2], KG[,3], KG[,4], KG[,5], 
    Einter[,1], Einter[,3], (as.integer(Einter[,2])+13))

## Returns all genes within 1 Kb of each probe in Einter.
## Probes that do not have a gene within 1 Kb are not returned.
NearestGenes <- AssociateWithGenes(KG[,1], KG[,2], KG[,3], KG[,4], KG[,5], 
    Einter[,1], Einter[,3], (as.integer(Einter[,2])+13), D=1000)



