### Name: import.exon.scheme
### Title: Import CLF, PGF and annotation files into a SchemeTreeSet
### Aliases: import.exon.scheme
### Keywords: manip

### ** Examples

## Not run: 
##D ## define paths
##D scmdir <- "/common/path/schemes"
##D libdir <- "/my/path/Affy/libraryfiles"
##D anndir <- "/my/path/Affy/Annotation"
##D 
##D ## create scheme for HuEx-1_0-st-v2.r2 Exon array
##D scheme.huex10stv2r2.na21 <- import.exon.scheme("Scheme_HuEx10stv2r2_na21",filedir=scmdir,
##D                             layoutfile=paste(libdir,"HuEx-1_0-st-v2_libraryfile/HuEx-1_0-st-r2/HuEx-1_0-st-v2.r2.clf",sep="/"),
##D                             schemefile=paste(libdir,"HuEx-1_0-st-v2_libraryfile/HuEx-1_0-st-r2/HuEx-1_0-st-v2.r2.pgf",sep="/"),
##D                             probeset=paste(anndir,"HuEx-1_0-st-v2.na21.hg18.probeset.csv",sep="/"),
##D                             transcript=paste(anndir,"HuEx-1_0-st-v2.na21.hg18.transcript.csv",sep="/"))
##D 
##D ## access ROOT scheme file from new R session
##D scheme.huex10stv2r2 <- root.scheme(paste(scmdir,"Scheme_HuEx10stv2r2_na21.root",sep="/"))
##D 
##D ## create scheme for HuEx-1_0-st-v2.r2 Exon array with the old annotation file
##D scheme.huex10stv2r2.old <- import.exon.scheme("Scheme_HuEx10stv2r2_old",filedir=scmdir,
##D                            layoutfile=paste(libdir,"HuEx-1_0-st-v2_libraryfile/HuEx-1_0-st-r2/HuEx-1_0-st-v2.r2.clf",sep="/"),
##D                            schemefile=paste(libdir,"HuEx-1_0-st-v2_libraryfile/HuEx-1_0-st-r2/HuEx-1_0-st-v2.r2.pgf",sep="/"),
##D                            probeset=paste(anndir,"HuEx-1_0-st-probeset-annot.csv",sep="/"),
##D                            transcript=paste(anndir,"HuEx-1_0-st-transcript-annot.csv",sep="/"),
##D                            control=paste(libdir,"HuEx-1_0-st-v2_libraryfile/HuEx-1_0-st-r2/HuEx-1_0-st-v2.r2.controls.ps",sep="/"))
## End(Not run)



