### Name: convert.output
### Title: Converts the output from the simulation to a format which can be
###   used by segmentation schemes available within R
### Aliases: convert.output
### Keywords: datasets

### ** Examples

## The function is currently defined as
function(input){
  holder <- list()
  for (i in 1:length(input)){
  holder[[i]] <- list()}
  for(i in 1:length(input)){
    holder[[i]]$genes <- matrix(NA, nrow = length(input[[i]]$clones$mid.point),
                                ncol = 2)
  }
  for(i in 1:length(input)){
    holder[[i]]$M <- as.matrix(input[[i]]$datamatrix)
    holder[[i]]$genes[,1] <- input[[i]]$clones$mid.point
    holder[[i]]$genes[,2] <- rep(input[[i]]$chrom,length(input[[i]]$clones$mid.point))
    colnames(holder[[i]]$genes) <- c("kb", "Chrom")
    holder[[i]] <- new("aCGHList", holder[[i]])
  }
  holder
  }



