### Name: import.gff
### Title: Importing tracks
### Aliases: import.gff import.gff,ANY-method import.gff1,ANY-method
###   import.gff2,ANY-method import.gff3,ANY-method import.wig,ANY-method
###   import.gff1 import.gff2 import.gff3 import.wig import.bed
###   import.bed,ANY-method import.ucsc import.ucsc,ANY-method
### Keywords: IO

### ** Examples

  # import a GFF V2 file
  gff <- import.gff(system.file("tests", "v2.gff", package = "rtracklayer"), version = "2")
  # or
  gff <- import.gff2(system.file("tests", "v2.gff", package = "rtracklayer"))

  # import a WIG file
  wig <- import.wig(system.file("tests", "bed.wig", package = "rtracklayer"))
  # or
  wig <- import.ucsc(system.file("tests", "bed.wig", package = "rtracklayer"),
                     subformat = "wig", drop = TRUE)



