### Name: export-tracks
### Title: Export tracks
### Aliases: export.gff export.gff,trackSet-method export.gff1 export.gff2
###   export.gff3 export.gff1,ANY-method export.gff2,ANY-method
###   export.gff3,ANY-method export.bed export.bed,trackSet-method
###   export.wig export.wig,trackSet-method export.ucsc
###   export.ucsc,trackSet-method export.ucsc,trackSets-method
### Keywords: IO

### ** Examples

  dummy <- file() # dummy file connection for demo
  track <- import(system.file("tests", "bed.wig", package = "rtracklayer"))
  ## output a track as GFF2
  export.gff(track, dummy, version = "2")
  ## equivalently
  export.gff2(track, dummy)
  ## output as WIG string in variableStep format
  wig <- export.wig(track, dummy, dataFormat = "variableStep")
  ## output multiple tracks in UCSC meta-format
  track2 <- import(system.file("tests", "v3.gff", package = "rtracklayer"), version = "3")
  ## output to WIG with BED line format
  export.ucsc(trackSets(track, track2), dummy, subformat = "wig", dataFormat = "bed") 



