###################################################
### chunk number 1: 
###################################################
library(rbsurv)
data(glioma)
ls()
dim(glioma.x) #Expresssion values of 100 genes for 85 patients
glioma.y[1:5,] #survival time and censoring status for 85 patients
glioma.cov[1:5,] #two covariates for 85 patients


time <- glioma.y$Time
status <- glioma.y$Status
z <- glioma.cov
x <- log2(glioma.x) #Transformation


###################################################
### chunk number 2: 
###################################################
fit <-  rbsurv(time=time, status=status, x=x, method="efron", max.n.genes=20)


###################################################
### chunk number 3: 
###################################################
par(mfrow=c(2,2))
plot(fit$model$Order, fit$model$nloglik, type="l")
plot(fit$model$Order, fit$model$AIC, type="l")

fit$model


