### Encoding: latin1

### Name: bpca
### Title: Bayesian PCA Missing Value Estimator
### Aliases: bpca
### Keywords: multivariate

### ** Examples

## Load a sample metabolite dataset with 5% missig values (metaboliteData)
data(metaboliteData)

## Perform Bayesian PCA with 2 components
result <- pca(metaboliteData, method="bpca", nPcs=2, center=FALSE)

## Get the estimated principal axes (loadings)
loadings <- result@loadings

## Get the estimated scores
scores <- result@scores

## Get the estimated complete observations
cObs <- result@completeObs

## Now make a scores and loadings plot
slplot(result)



