###################################################
### chunk number 1: no.nonsense
###################################################
rm(list=ls())


###################################################
### chunk number 2: 
###################################################
library(nem)
data("BoutrosRNAi2002")


###################################################
### chunk number 3: 
###################################################
res.disc <- nem.discretize(BoutrosRNAiExpression,neg.control=1:4,pos.control=5:8,cutoff=.7)


###################################################
### chunk number 4: 
###################################################
disc <- cbind(res.disc$neg,res.disc$pos,res.disc$dat)
e.2fold <- BoutrosRNAiExpression[res.disc$sel,]

#--- hierarchisch clustern
hc    <- hclust(as.dist(hamming.distance(disc[,9:16])))
e.2fold <- e.2fold[hc$order, ]
disc  <- disc [hc$order, ]


###################################################
### chunk number 5: data_cont
###################################################
#--- CONTINUOUS DATA
#pdf("data_cont.pdf",width=5,height=13)
par(las=2,mgp=c(5.5,1,0),mar=c(6.7,7,4,1),cex.lab=1.7,cex.main=2)
image(x   = 1:ncol(e.2fold),
y   = 1:nrow(e.2fold),
z   = scale(t(e.2fold)),
main= "Original data",
xlab= "Experiments",
xaxt= "n",
ylab= "E-genes",
yaxt= "n",
col = gray(seq(0,.95,length=10))
)
abline(v=c(4,8,10,12,14)+.5)
axis(1,1:ncol(e.2fold),colnames(e.2fold))
axis(2,1:nrow(e.2fold),rownames(e.2fold))
#dev.off()


###################################################
### chunk number 6: data_disc
###################################################
#--- DISCRETE DATA
#pdf("data_disc.pdf",width=5,height=13)
par(las=2,mgp=c(5.5,1,0),mar=c(6.7,7,4,1),cex.lab=1.7,cex.main=2)
image(x   = 1:ncol(disc),
      z   = t(disc),
      main= "Discretized data",
      xlab= "Experiments",
      xaxt= "n",
      ylab= "",
      yaxt= "n",
      col = gray(seq(.95,0,length=10))
      )
abline(v=c(4,8,10,12,14)+.5)
axis(1,1:ncol(e.2fold),colnames(e.2fold))
#dev.off()


###################################################
### chunk number 7: 
###################################################
res.disc$para


###################################################
### chunk number 8: 
###################################################
result <- nem(res.disc$dat,type="mLL",para=res.disc$para,inference="search",verbose=FALSE)
result


###################################################
### chunk number 9: 
###################################################
plot(result,what="graph")
plot(result,what="mLL")
plot(result,what="pos")


###################################################
### chunk number 10: 
###################################################
Sgenes <- unique(colnames(res.disc$dat))
models <- enumerate.models(Sgenes)
best5 <- -sort(-unique(result$mLL))[1:5]
col<-c("yellow","yellow","green","blue")
names(col) = Sgenes
for (i in 1:5) {
   graph <- as(models[[which(result$mLL == best5[i])[1]]]-diag(4),"graphNEL")
   pdf(file=paste("topo",i,".pdf",sep=""))
   par(cex.main=5)
   plot(graph,
        nodeAttrs=list(fillcolor=col),
        main=paste("-",i, "-"))        
   dev.off()
   }


###################################################
### chunk number 11: scores1
###################################################
plot(result,what="mLL")


###################################################
### chunk number 12: pos1
###################################################
plot(result,what="pos")


###################################################
### chunk number 13: 
###################################################
result2 <- nem(res.disc$dat,type="FULLmLL",hyperpara=c(1,9,9,1),inference="search",verbose=FALSE)
result2


###################################################
### chunk number 14: 
###################################################
best5 <- -sort(-unique(result2$mLL))[1:5]
for (i in 1:5) {
   graph <- as(models[[which(result2$mLL == best5[i])[1]]]-diag(4),"graphNEL")
   pdf(file=paste("topo2",i,".pdf",sep=""))
   par(cex.main=5)
   plot(graph,
        nodeAttrs=list(fillcolor=col),
        main=paste("-",i, "-"))
   dev.off()
   }


###################################################
### chunk number 15: scores2
###################################################
plot(result2,what="mLL")


###################################################
### chunk number 16: pos2
###################################################
plot(result2,what="pos")


###################################################
### chunk number 17: 
###################################################
resultPairs <- nem(res.disc$dat,para=res.disc$para,inference="pairwise",verbose=FALSE)
resultPairs


###################################################
### chunk number 18: graph3
###################################################
col<-c("yellow","yellow","green","blue")
names(col) = nodes(resultPairs$graph)
plot(resultPairs, nodeAttrs=list(fillcolor=col))


###################################################
### chunk number 19: 
###################################################
resultTriples <- nem(res.disc$dat,para=res.disc$para,inference="triples",verbose=FALSE)
resultTriples


###################################################
### chunk number 20: graph4
###################################################
col<-c("yellow","yellow","green","blue")
names(col) = nodes(resultTriples$graph)
plot(resultTriples$graph, nodeAttrs=list(fillcolor=col))


###################################################
### chunk number 21: 
###################################################
resultGreedy <- nem(res.disc$dat,para=res.disc$para,inference="nem.greedy",verbose=FALSE)
resultGreedy


###################################################
### chunk number 22: graph44
###################################################
col<-c("yellow","yellow","green","blue")
names(col) = nodes(resultGreedy$graph)
plot(resultGreedy$graph, nodeAttrs=list(fillcolor=col))


###################################################
### chunk number 23: 
###################################################
resultMN <- nem(res.disc$dat,para=res.disc$para,inference="ModuleNetwork",verbose=FALSE)
resultMN # will do exactly the same as exhaustive search in this case


###################################################
### chunk number 24: 
###################################################
resultRegularization <- nem(res.disc$dat,para=res.disc$para,Pm=matrix(0,ncol=4,nrow=4), lambda=10, inference="search", verbose=FALSE)
resultRegularization


###################################################
### chunk number 25: graph6
###################################################
col<-c("yellow","yellow","green","blue")
names(col) = nodes(resultRegularization$graph)
plot(resultRegularization, nodeAttrs=list(fillcolor=col))


###################################################
### chunk number 26: 
###################################################
resultModsel <- nemModelSelection(c(0.01,1,100),res.disc$dat,para=res.disc$para,Pm=matrix(0,ncol=4,nrow=4),verbose=FALSE)


###################################################
### chunk number 27: graph7
###################################################
col<-c("yellow","yellow","green","blue")
names(col) = nodes(resultModsel$graph)
plot(resultModsel, nodeAttrs=list(fillcolor=col))


###################################################
### chunk number 28: 
###################################################
resultBayes <- nem(res.disc$dat,para=res.disc$para,Pm=matrix(0,ncol=4,nrow=4), verbose=FALSE)
resultBayes


###################################################
### chunk number 29: graph77
###################################################
col<-c("yellow","yellow","green","blue")
names(col) = nodes(resultBayes$graph)
plot(resultBayes, nodeAttrs=list(fillcolor=col))


###################################################
### chunk number 30:  eval=FALSE
###################################################
## logdensities = getDensityMatrix(myPValueMatrix,dirname="DiagnosticPlots")
## nem(logdensities[res.disc$sel,],type="CONTmLLDens",inference="search")
## 
## preprocessed <- nem.cont.preprocess(BoutrosRNAiExpression,neg.control=1:4,pos.control=5:8)
## nem(preprocessed$prob.influenced,type="CONTmLL",inference="search")


###################################################
### chunk number 31:  eval=FALSE
###################################################
## mydat = filterEGenes(Porig, logdensities) # a-priori filtering of E-genes
## resAuto = nem(mydat,type="CONTmLLDens",selEGenes=TRUE) # automated subset selection of  E-genes 


###################################################
### chunk number 32:  eval=FALSE
###################################################
## significance=nem.calcSignificance(res,disc$dat, as(resultGreedy$graph,"matrix"),resultGreedy$mLL,para=res.disc$para) # assess statistical significance
## bootres=nem.bootstrap(res.disc$dat,para=res.disc$para) # bootstrapping on E-genes
## jackres=nem.jackknife(res.disc$dat,para=res.disc$para) # jackknife on S-genes


###################################################
### chunk number 33: 
###################################################
plot.effects(res.disc$dat,result)


###################################################
### chunk number 34: plot_effects
###################################################
plot.effects(res.disc$dat,result)


###################################################
### chunk number 35: 
###################################################
result.scc <- SCCgraph(result$graph,name=TRUE)
plot(result.scc$graph)


###################################################
### chunk number 36: scc
###################################################
# col2<-c("yellow","blue","green")
# names(col2) = nodes(result.scc$graph)
plot(result.scc$graph)#,nodeAttrs=list(fillcolor=col2))


###################################################
### chunk number 37: 
###################################################
toLatex(sessionInfo())


