###################################################
### chunk number 1: 
###################################################
options(width=70)


###################################################
### chunk number 2: 
###################################################
library("annotate")
data(sample.ExpressionSet)
igenes <- featureNames(sample.ExpressionSet)[246:260]


###################################################
### chunk number 3: 
###################################################
library("biomaRt")
mart <- useMart("ensembl", "hsapiens_gene_ensembl")


###################################################
### chunk number 4: 
###################################################
attrbuts <- listAttributes(mart)
attrbuts[grep("swiss", attrbuts[,1]),]
attrbuts[grep("entrez", attrbuts[,1]),]


###################################################
### chunk number 5: 
###################################################
fltr <- listFilters(mart)
fltr[grep("affy", fltr[,1]),]


###################################################
### chunk number 6: 
###################################################
genelist <- getBM(attributes = c("affy_hg_u95av2","entrezgene","uniprot_swissprot_accession","refseq_dna"),
                  filter = "affy_hg_u95av2", values = igenes, mart = mart,
                  output = "list", na.value = "&nbsp;")
genelist[[1]] <- igenes

## let's look at genelist values
lapply(genelist, function(x) x[5:10])


###################################################
### chunk number 7: 
###################################################
attrbuts[grep("description", attrbuts[,1]),]
attrbuts[grep("symbol", attrbuts[,1]),]
attrbuts[grep("go", attrbuts[,1]),]
attrbuts[grep("^chrom", attrbuts[,1]),]


###################################################
### chunk number 8: 
###################################################
annotlist <- getBM(attributes = c("description", "hgnc_symbol", "go_biological_process_id", "band"),
                   filter = "affy_hg_u95av2", values = igenes, mart = mart,
                  output = "list",na.value = "&nbsp;")


###################################################
### chunk number 9:  eval=FALSE
###################################################
## lapply(annotlist, function(x) x[5:10])


###################################################
### chunk number 10: 
###################################################
prntlist <- vector("list", 4)
prntlist <- lapply(annotlist[1:3], function(x) lapply(x[5:10], strwrap))
prntlist[[4]] <- annotlist[[4]][5:10]
prntlist


###################################################
### chunk number 11: expDat
###################################################
dat <- round(exprs(sample.ExpressionSet)[igenes,1:10], 3)
FC <- round(rowMeans(dat[igenes,1:5]) - rowMeans(dat[igenes,6:10]), 2)
pval <- round(esApply(sample.ExpressionSet[igenes,1:10], 1, 
                      function(x) t.test(x[1:5], x[6:10])$p.value), 3)
tstat <- round(esApply(sample.ExpressionSet[igenes,1:10], 1, 
                       function(x) t.test(x[1:5], x[6:10])$statistic), 2)


###################################################
### chunk number 12: 
###################################################
othernames <- vector("list", length = 8)
othernames[1:4] <- annotlist
othernames[5:8] <- list( tstat, pval, FC, dat)


###################################################
### chunk number 13: 
###################################################
table.head <- c("Affy ID", "Entrez Gene", "SwissProt", "RefSeq",
                "Name","Symbol","GO Term", "Band",
                "t-statistic","p-value","Fold change", 
                sampleNames(sample.ExpressionSet)[1:10])
repository  <- list("affy","en","sp","gb")
htmlpage(genelist, "Annotated genes.html", "Annotated genes", othernames, table.head,
         repository = repository)


###################################################
### chunk number 14: 
###################################################
sessionInfo()


