### Name: CoHyperGResult-class
### Title: Class "CoHyperGResult"
### Aliases: CoHyperGResult-class summary,CoHyperGResult-method
###   geneCounts,CoHyperGResult-method pvalues,CoHyperGResult-method
###   oddsRatios,CoHyperGResult-method universeCounts,CoHyperGResult-method
###   expectedCounts,CoHyperGResult-method
### Keywords: classes

### ** Examples

data(DudleyPhenoM)
data(ScISIC)

## Select genes sensitive to paraquat
DudleyPhenoL <- apply(DudleyPhenoM,2,function(x) names(which(x==1)))
paraquat <- DudleyPhenoL[["Paraq"]]

## Apply a hypergeometric test
params <- new("CoHyperGParams",
              geneIds=paraquat, 
              universeGeneIds=rownames(ScISIC),
              annotation="YEAST",
              categoryName="ScISIC",
              pvalueCutoff=0.01,
              testDirection="over")

paraquat.complex <- hyperGTest(params)

## access the p-values
pvalues(paraquat.complex)[1:5]

## Display a summary of the results
summary(paraquat.complex)[,1:4]



