###################################################
### chunk number 1: 
###################################################
options(width=50)


###################################################
### chunk number 2: 
###################################################
library(GenomeGraphs)


###################################################
### chunk number 3: 
###################################################
mart = useMart("ensembl", dataset="hsapiens_gene_ensembl")


###################################################
### chunk number 4: 
###################################################
gene = new("Gene", id = "ENSG00000095203", type="ensembl_gene_id", biomart = mart)
gdPlot(list(gene), minBase= 110974000, maxBase = 111122900)


###################################################
### chunk number 5: 
###################################################
transcript = new("Transcript", id = "ENSG00000095203", type="ensembl_gene_id", biomart = mart)
gdPlot(list(gene, transcript), minBase= 110974000, maxBase = 111122900)


###################################################
### chunk number 6: 
###################################################
plusStrand = new("GeneRegion", chromosome = "17", start = 30450000, end = 30550000, strand = "+", biomart = mart)
genomeAxis = new("GenomeAxis", add53=TRUE)
gdPlot(list(genomeAxis, plusStrand), minBase = 30450000, maxBase =  30550000)


###################################################
### chunk number 7: 
###################################################
minStrand = new("GeneRegion", chromosome = "17", start = 30450000, end = 30550000, strand = "-", biomart = mart)
ideogram = new("Ideogram", chromosome = "17")
genomeAxis = new("GenomeAxis", add53=TRUE, add35=TRUE)
gdPlot(list(ideogram, plusStrand, genomeAxis, minStrand), minBase = 30450000, maxBase =  30550000)


###################################################
### chunk number 8: 
###################################################
data("dummyData", package="GenomeGraphs")

minbase <- 180292097 
maxbase <- 180492096

genesplus <- new("GeneRegion", start = minbase, end = maxbase, 
                 strand = "+", chromosome = "3", biomart=mart)
genesmin <- new("GeneRegion", start = minbase, end = maxbase, 
                strand = "-", chromosome = "3", biomart=mart)

seg <- new("Segmentation", segments = segments, 
           segmentStart = segStart, segmentEnd = segEnd, 
           dp = DisplayPars(color = "black", lwd=2,lty = "solid"))

cop <- new("GenericArray", intensity  = cn, probeStart = probestart, 
           segmentation =  seg, dp = DisplayPars(size=3, color = "seagreen", type="dot"))

ideog <- new("Ideogram", chromosome = "3")
expres <- new("GenericArray", intensity = intensity, probeStart = exonProbePos, 
              dp = DisplayPars(color="darkred", type="point"))
genomeAxis <- new("GenomeAxis", add53 = TRUE, add35=TRUE)

gdPlot(list(a=ideog,b=expres,c=cop,d=genesplus,e=genomeAxis,f=genesmin), 
       minBase = minbase, maxBase =maxbase)


###################################################
### chunk number 9: 
###################################################
data("unrData", package="GenomeGraphs")

title <- new("Title", title ="ENSG00000009307", dp = DisplayPars(color = "darkred"))
exon <- new("ExonArray", intensity = unrData, probeStart = unrPositions[,3], 
            probeEnd=unrPositions[,4], probeId = as.character(unrPositions[,1]), 
            nProbes = unrNProbes, dp = DisplayPars(color = "blue", mapColor = "dodgerblue2"), 
            displayProbesets=FALSE)
affyModel <- new("GeneModel", exonStart = unrPositions[,3], exonEnd =  unrPositions[,4])
gene <- new("Gene", id = "ENSG00000009307", biomart = mart)
transcript <- new("Transcript", id ="ENSG00000009307" , biomart = mart)
legend <- new("Legend", legend = c("affyModel","gene"), 
              dp = DisplayPars(color= c("darkgreen","orange")))

gdPlot(list(title, exon, affyModel, gene, transcript, legend), 
       minBase = min(exon@probeStart), maxBase=max(exon@probeEnd))


###################################################
### chunk number 10: 
###################################################
yeastMart <- useMart("ensembl", dataset = "scerevisiae_gene_ensembl")

minB <- 10000
maxB <- 20000

chrRoman <- as.character(as.roman(1))

grP <- new("GeneRegion", start = minB, end = maxB, 
           strand = "+", chromosome = chrRoman, biomart = yeastMart)
grM <- new("GeneRegion", start = minB, end = maxB, 
           strand = "-", chromosome = chrRoman, biomart = yeastMart)
gaxis <- new("GenomeAxis", add53 = TRUE, add35 = TRUE)
  
conserv <- yeastCons1[yeastCons1[,1] > minB & yeastCons1[,1] < maxB, ]

consTrack <- new("BaseTrack", base = conserv[, 1], value = conserv[,2],
                 dp = DisplayPars(lwd=.2, ylim = c(0, 1.25), color = "darkblue"))

gdPlot(list(grP, gaxis, grM, "conservation" = consTrack), minBase = minB, maxBase = maxB)


###################################################
### chunk number 11: 
###################################################
plotGeneRegion <- function(chr = 1, minB = 9000, maxB = 13000, rot = 0, col = "green") {
  chrRoman <- as.character(as.roman(1:17)[chr])
  grP <- new("GeneRegion", start = minB, end = maxB, 
             strand = "+", chromosome = chrRoman, biomart = yeastMart, 
             dp = DisplayPars(plotId = TRUE, idRotation = rot, 
             idColor = col))
  gaxis <- new("GenomeAxis", add53 = TRUE, add35 = TRUE, littleTicks = FALSE)
  gdPlot(list(grP, gaxis), minBase = minB, maxBase = maxB)
}
plotGeneRegion(col = "yellow", rot=90)


###################################################
### chunk number 12: 
###################################################
gdPlot(new("GeneRegion", start = 9000, end = 15000, biomart = yeastMart,
           strand = "-", chromosome = "I", dp = DisplayPars(plotId=TRUE)))


###################################################
### chunk number 13: 
###################################################
ga <- new("GenomeAxis")
grF <- new("GeneRegion", start = 10000, end = 20000, chromosome = "I", strand = "+", biomart = yeastMart)
grR <- new("GeneRegion", start = 10000, end = 20000, chromosome = "I", strand = "-", biomart = yeastMart)
bt <- new("BaseTrack", base = yeastCons1[,1], value = yeastCons1[,2])
hr1 <- new("HighlightRegion", start = 11000, end = 13000)
hr2 <- new("HighlightRegion", start = 15900, end = 16500)
          
gdPlot(list(grF, ga, grR, bt), highlightRegions = list(hr1, hr2))


###################################################
### chunk number 14: 
###################################################
hr <- new("HighlightRegion", start = 11000, end = 13000, region = c(1,3), 
          dp = DisplayPars(color = "green", alpha = .3))
gdPlot(list(grF, ga, grR, bt), highlightRegions = hr)


###################################################
### chunk number 15: 
###################################################
hrR <- new("HighlightRegion", start = .1, end = .3, coords = "absolute",
           dp = DisplayPars(color = "grey", alpha = 0, lty = "dashed"),
           region = c(.4,.7))
gdPlot(list(grF, ga, grR, bt), highlightRegions = list(hr, hrR))


