###################################################
### chunk number 1: 
###################################################
library(CGHcall)
data(Wilting)
Wilting <- make_cghRaw(Wilting)


###################################################
### chunk number 2: 
###################################################
cghdata <- preprocess(Wilting, maxmiss=30, nchrom=22)


###################################################
### chunk number 3: 
###################################################
tumor.prop <- c(0.75, 0.9, 0.8, 1, 1)
norm.cghdata <- normalize(cghdata, method="median", cellularity=tumor.prop, smoothOutliers=TRUE)


###################################################
### chunk number 4: 
###################################################
norm.cghdata <- norm.cghdata[,1:2]
seg.cghdata <- segmentData(norm.cghdata, method="DNAcopy")


###################################################
### chunk number 5: 
###################################################
result <- CGHcall(seg.cghdata)


###################################################
### chunk number 6: 
###################################################
plot(result[,1])


###################################################
### chunk number 7: 
###################################################
plot(result[,2])


###################################################
### chunk number 8: 
###################################################
plot.summary(result)


