### Name: cghSeg
### Title: Class to contain and describe segmented array comparative
###   genomic hybridization data.
### Aliases: class:cghSeg cghSeg cghSeg-class copynumber,cghSeg-method
###   copynumber<-,cghSeg,matrix-method segmented,cghSeg-method
###   segmented<-,cghSeg,matrix-method chromosomes,cghSeg-method
###   bpstart,cghSeg-method bpend,cghSeg-method initialize,cghSeg-method
###   plot,cghSeg,missing-method
### Keywords: classes

### ** Examples

# create an instance of cghSeg
new("cghSeg")

# create an instance of cghSeg through this-is-escaped-codenormal-bracket105bracket-normal
## Not run: 
##D    data(Wilting)
##D    rawcgh <- make_cghRaw(Wilting)
##D    cghdata <- preprocess(cghdata)
##D    normalized <- normalize(cghdata)
##D    segmented <- segmentData(normalized)
##D 
##D    # plot the first sample
##D    plot(segmented[,1])
##D    # first three chromosomes
##D    plot(segmented[chromosomes(segmented)==1,1])
##D 
##D    # get the copynumber values of the third and fourth sample
##D    log2ratios <- copynumber(segmented[,3:4])
##D 
##D    # get the names of the samples
##D    sampleNames(segmented)
##D 
##D    # get the names of the array elements
##D    featureNames(segmented)
## End(Not run)



