### Name: matchPDict-inexact
### Title: Inexact matching with matchPDict()
### Aliases: matchPDict-inexact
### Keywords: methods

### ** Examples

  ## WARNING! THIS IS STILL WORK IN PROGRESS!!!
  ## A known issue is that the "startIndex", "[[" and "unlist" methods are
  ## BROKEN on the MIndex object returned by matchPDict() called on a
  ## TBdna_PDict object!

  ## ---------------------------------------------------------------------
  ## A. WITH UNNAMED PATTERNS
  ## ---------------------------------------------------------------------

  library(drosophila2probe)
  dict0 <- drosophila2probe$sequence  # The input dictionary.

  ## Specify the length of the Trusted Prefix via the 'tb.end' argument
  pdict9 <- PDict(dict0, tb.end=9)
  pdict9
  tail(pdict9)
  #sum(duplicated(pdict9)) # not ready yet!
  #table(patternFrequency(pdict9)) # not ready yet!

  library(BSgenome.Dmelanogaster.UCSC.dm3)
  chr3R <- Dmelanogaster$chr3R
  chr3R
  table(countPDict(pdict9, chr3R, max.mismatch=1))
  table(countPDict(pdict9, chr3R, max.mismatch=3))
  table(countPDict(pdict9, chr3R, max.mismatch=5))

  ## ---------------------------------------------------------------------
  ## B. COMPARISON WITH EXACT MATCHING
  ## ---------------------------------------------------------------------

  ## When the input dictionary is of constant width, using 'max.mismatch=0'
  ## on the Trusted Prefix dictionary is equivalent to (but much slower than)
  ## using the full dictionary.
  pdict0 <- PDict(dict0)
  count0 <- countPDict(pdict0, chr3R)
  count_tp9_mm0 <- countPDict(pdict9, chr3R, max.mismatch=0)
  identical(count_tp9_mm0, count0)    # TRUE
  
  ## ---------------------------------------------------------------------
  ## C. VARIABLE WIDTH DICTIONARY
  ## ---------------------------------------------------------------------

  pdict <- PDict(c("ACNG", "GT", "CGT", "AC"), tb.end=2)
  pdict
  tail(pdict) 
  endIndex(matchPDict(pdict, DNAString("ACGGACCG"), max.mismatch=0))
  endIndex(matchPDict(pdict, DNAString("ACGGACCG"), max.mismatch=1))
  mindex <- matchPDict(pdict, DNAString("ACGGACCG"), max.mismatch=2)
  endIndex(mindex)

  startIndex(mindex)                  # CURRENTLY BROKEN!
  mindex[[1]]                         # CURRENTLY BROKEN!
  unlist(mindex)                      # CURRENTLY BROKEN!

  ## -------------------------------------------------------------------------
  ## D. WITH AMBIGUITIES IN THE TAIL
  ## -------------------------------------------------------------------------

  ## Ambiguities (IUPAC extended letters) are supported in the tail only:
  endIndex(matchPDict(pdict, DNAString("ACGGACCG"), fixed=FALSE))



