### Name: matchLRPatterns
### Title: Find patterns defined by a left and a right part in a sequence
### Aliases: matchLRPatterns matchLRPatterns,XString-method
###   matchLRPatterns,XStringViews-method
###   matchLRPatterns,MaskedXString-method
### Keywords: methods

### ** Examples

  library(BSgenome.Dmelanogaster.UCSC.dm3)
  subject <- Dmelanogaster$chr3R
  Lpattern <- "AGCTCCGAG"
  Rpattern <- "TTGTTCACA"
  matchLRPatterns(Lpattern, Rpattern, 500, subject) # 1 match

  ## Note that matchLRPatterns() will return all matches, even when they are
  ## overlapping:
  subject <- DNAString("AAATTAACCCTT")
  matchLRPatterns("AA", "TT", 0, subject) # 1 match
  matchLRPatterns("AA", "TT", 1, subject) # 2 matches
  matchLRPatterns("AA", "TT", 3, subject) # 3 matches
  matchLRPatterns("AA", "TT", 7, subject) # 4 matches



