###################################################
### chunk number 1: setup0
###################################################
options(continue=" ", prompt="R> ", width=72L)


###################################################
### chunk number 2: setup
###################################################
library("hgu95av2.db")


###################################################
### chunk number 3: objects
###################################################
ls("package:hgu95av2.db")


###################################################
### chunk number 4: QAlisting
###################################################
qcdata = capture.output(hgu95av2())
head(qcdata, 20)


###################################################
### chunk number 5: mapcounts eval=FALSE
###################################################
## hgu95av2MAPCOUNTS


###################################################
### chunk number 6: envApiDemo1
###################################################
all_probes <- ls(hgu95av2ENTREZID)
length(all_probes)

set.seed(0xa1beef)
probes <- sample(all_probes, 5)
probes


###################################################
### chunk number 7: envApiDemo2
###################################################
hgu95av2ENTREZID[[probes[1]]]
hgu95av2ENTREZID$"31882_at"

syms <- unlist(mget(probes, hgu95av2SYMBOL))
syms



###################################################
### chunk number 8: as.list eval=FALSE
###################################################
## zz <- as.list(hgu95av2SYMBOL)


###################################################
### chunk number 9: oldRevMap
###################################################
library("hgu95av2", warn.conflicts=FALSE)
## we load the environment so as not
## to include the load time in the timing
class(hgu95av2SYMBOL)
system.time({
    p2sym <- as.list(hgu95av2SYMBOL)
    lens <- sapply(p2sym, length)
    nms <- rep(names(p2sym), lens)
    sym2p <- split(unlist(p2sym), nms)
    })

## in fact, there is a convenience function
## for this operation in Biobase
system.time({
    p2sym <- as.list(hgu95av2SYMBOL)
    sym2p <- reverseSplit(p2sym)
    })
detach("package:hgu95av2")


###################################################
### chunk number 10: show.revmap
###################################################
system.time(sym2p <- revmap(hgu95av2SYMBOL))

unlist(mget(syms, revmap(hgu95av2SYMBOL)))


###################################################
### chunk number 11: thisworks
###################################################
as.list(revmap(hgu95av2PATH)["00300"])


###################################################
### chunk number 12: revmap2
###################################################
x <- hgu95av2PATH
## except for the name, this is exactly revmap(x)
revx <- hgu95av2PATH2PROBE
revx2 <- revmap(x, objName="PATH2PROBE")
revx2
identical(revx, revx2)

as.list(revx["00300"])


###################################################
### chunk number 13: toTable
###################################################
toTable(hgu95av2GO[probes[1:3]])


###################################################
### chunk number 14: undirectedMethod
###################################################
toTable(x)[1:6, ]
toTable(revx)[1:6, ]


###################################################
### chunk number 15: threecols
###################################################
toTable(hgu95av2PFAM)[1:6, ]  # the right values are tagged
as.list(hgu95av2PFAM["1000_at"])


###################################################
### chunk number 16: directedMethods
###################################################
length(x)
length(revx)
allProbeSetIds <- keys(x)
allKEGGIds <- keys(revx)


###################################################
### chunk number 17: moreUndirectedMethods
###################################################
junk <- Lkeys(x)        # same for all maps in hgu95av2.db (except pseudo-map
                        # MAPCOUNTS)
Llength(x)              # nb of Lkeys
junk <- Rkeys(x)        # KEGG ids for PATH/PATH2PROBE maps, GO ids for
                        # GO/GO2PROBE/GO2ALLPROBES maps, etc...
Rlength(x)              # nb of Rkeys


###################################################
### chunk number 18: revmapUseCases
###################################################
x <- hgu95av2CHR
Rkeys(x)
chroms <- Rkeys(x)[23:24]
chroms
Rkeys(x) <- chroms
toTable(x)[1:10, ]


###################################################
### chunk number 19: easy
###################################################
z <- as.list(revmap(x)[chroms])
names(z)
z[["Y"]][1:5]


###################################################
### chunk number 20: hard eval=FALSE
###################################################
##   library(hgu95av2)
##   u <- unlist(as.list(hgu95av2CHR))
##   u <- u[u %in% chroms]
##   split(names(u), u)


###################################################
### chunk number 21: cytogenicLoc
###################################################
x <- hgu95av2MAP
toTable(hgu95av2MAP)[1:6, ]
as.list(revmap(x)["8p22"])


###################################################
### chunk number 22: cytogenetic2
###################################################
pbids <- c("38912_at", "41654_at", "907_at", "2053_at", "2054_g_at", 
           "40781_at")
x <- subset(x, Lkeys=pbids, Rkeys="18q11.2")
toTable(x)


###################################################
### chunk number 23: coerce
###################################################
  pb2cyto <- as.character(x)
  pb2cyto[pbids]


###################################################
### chunk number 24: hmm
###################################################
  cyto2pb <- as.character(revmap(x))


###################################################
### chunk number 25: complexEnv
###################################################
## Obtain SYMBOLS with at least one GO BP
## annotation with evidence IMP, IGI, IPI, or IDA.
probes <- sample(all_probes, 500)

library("hgu95av2", warn.conflicts=FALSE)
system.time({
bpids <- eapply(hgu95av2GO, function(x) {
    if (length(x) == 1 && is.na(x))
      NA
    else {
        sapply(x, function(z) {
            if (z$Ontology == "BP")
              z$GOID
            else
              NA
            })
    }
})
bpids <- unlist(bpids)
bpids <- unique(bpids[!is.na(bpids)])
g2p <- mget(bpids, hgu95av2GO2PROBE)
wantedp <- lapply(g2p, function(x) {
    x[names(x) %in% c("IMP", "IGI", "IPI", "IDA")]
})
wantedp <- wantedp[sapply(wantedp, length) > 0]
wantedp <- unique(unlist(wantedp))
ans <- unlist(mget(wantedp, hgu95av2SYMBOL))
})
detach("package:hgu95av2")
length(ans)
ans[1:10]


###################################################
### chunk number 26: schema
###################################################
hgu95av2_dbschema() 


###################################################
### chunk number 27: complexDb
###################################################
system.time({
SQL <- "SELECT symbol FROM go_bp INNER JOIN gene_info USING(_id)
        WHERE go_bp.evidence in ('IPI', 'IDA', 'IMP', 'IGI')"
zz <- dbGetQuery(hgu95av2_dbconn(), SQL)
})


###################################################
### chunk number 28: GO_hgu95av2_join
###################################################

goDBLoc = system.file("extdata", "GO.sqlite", package="GO.db")
attachSQL = paste("ATTACH '", goDBLoc, "' as goDB;", sep = "")
dbGetQuery(hgu95av2_dbconn(), attachSQL)


###################################################
### chunk number 29: crossDBQuery
###################################################
selectSQL = paste("SELECT DISTINCT a.go_id AS 'hgu95av2.go_id',",
            "a._id AS 'hgu95av2._id',",
            "g.go_id AS 'GO.go_id', g._id AS 'GO._id',",
            "g.ontology",
            "FROM go_bp_all AS a, goDB.go_term AS g",
            "WHERE a.go_id = g.go_id LIMIT 10;")
dataOut = dbGetQuery(hgu95av2_dbconn(), selectSQL)
dataOut
#just to clean up we can now detach the GO database...
detachSQL = paste("DETACH goDB")
dbGetQuery(hgu95av2_dbconn(), detachSQL)


