### Name: plotvar.FCS
### Title: Making Univariate/Bivariate plots of the column variables of a
###   FCS object
### Aliases: plotvar.FCS
### Keywords: hplot

### ** Examples


  ### to identify all the colors available on your system
  colors()
  if (interactive()) {
    if (require(rfcdmin)) {

      if (!is.element("unst.1829", objects())) {
        ## obtaining the FCS objects from VRC data
        data(VRCmin)
      }

      ## univariate plot
      plotvar.FCS(unst.1829, varpos=1)

      ## bivariate plot :hexagonal binning
      plotvar.FCS(unst.1829, varpos=c(1,2))

      ## bivariate plot :rectangonal binning
      plotvar.FCS(unst.1829, varpos=c(1,2), hexbin.CSPlot=FALSE)
    }
  }




