### Name: "FCS-class"
### Title: Class "FCS" : Flow Cytometry Standard
### Aliases: "FCS" FCS-class FCS "FCS-class" [,FCS-method [<-,FCS-method
###   [[,FCS-method [[<-,FCS-method [[<-,FCS, ANY, ANY
###   "[-methods",FCS-method "[<--methods",FCS-method
###   "[[-methods",FCS-method "[[<--methods",FCS-method
###   addParameter,FCS,vector-method checkvars,FCS-method
###   coerce,FCS,matrix-method coerce,FCS,data.frame-method
###   coerce,matrix,FCS-method coerce,data.frame,FCS-method
###   dim.FCS,FCS-method equals,FCS,FCS-method fixvars,FCS-method
###   fluors,FCS-method ggobi,FCS-method metaData,FCS-method
###   plot,FCS,missing-method print,FCS-method show,FCS-method
###   summary,FCS-method "addParameter-methods",FCS,vector-method
###   "checkvars-methods",FCS-method "coerce-methods",FCS,matrix-method
###   "coerce-methods",FCS,data.frame-method
###   "coerce-methods",matrix,FCS-method
###   "coerce-methods",data.frame,FCS-method "dim.FCS-methods",FCS-method
###   "equals-methods",FCS,FCS-method "fixvars-methods",FCS-method
###   "fluors-methods",FCS-method "ggobi-methods",FCS-method
###   "metaData-methods",FCS-method "plot-methods",FCS,missing-method
###   "print-methods",FCS-method "show-methods",FCS-method
###   "summary-methods",FCS-method
### Keywords: classes

### ** Examples


## a default FCS object
default.FCSobj<-new("FCS")

## making my own FCS object
## first making up the data
dummy.data<-matrix(1:1000, ncol=10)
colnames(dummy.data)<-paste("foo", 1:10, sep="")

## second making up the metadata
##   default FCSmetadata
dummy.metadata<-new("FCSmetadata")
##   user-defined metadata
foo.metadata<-new("FCSmetadata", mode="none", size=100, nparam=10,
shortnames=paste("V", 1:10, sep=""), longnames=colnames(dummy.data),
paramranges=unlist(apply(dummy.data, 2, max)), filename="",
objectname="foo.FCSobj", fcsinfo=list("extraInfo1"="dummy FCS",
"extraInfo2"=9:20))

foo.FCSobj<-new("FCS", data=dummy.data, metadata=foo.metadata)

dummy.FCSobj<-new("FCS", data=matrix(), metadata=dummy.metadata)

## extraction of the metadata
foo.FCSobj[["size"]]
## replacement of the metadata
 ## introduce an error in the column length
foo.FCSobj[["nparam"]]<-0

## extraction of the data

first.ten.obs<-foo.FCSobj[1:10,]
## replacement of the data
foo.FCSobj[1:10,]<-matrix(1:100, ncol=10)
## addParameter
foo.FCSobj<-addParameter(foo.FCSobj, 1:100, shortname="newvar",
longname="newlymadevariable", use.shortname=FALSE)

## replacement of the metadata
 ## introduce an error in the column length
foo.FCSobj[["nparam"]]<-0

## checkvars
correct.status.is.FALSE<-checkvars(foo.FCSobj)
## coerce FCS to matrix
coerced.mat<-as(foo.FCSobj, "matrix")
is(coerced.mat, "matrix")
## coerce FCS to data.frame
coerced.df<-as(foo.FCSobj, "data.frame")
is(coerced.df, "data.frame")
## coerce matrix to FCS
FCSobj1<-as(coerced.mat, "FCS")
is(FCSobj1, "FCS")
## coerce data.frame to FCS
FCSobj2<-as(coerced.df, "FCS")
is(FCSobj2, "FCS")

##obtaining the dimensions of the data
dim.FCS(FCSobj2)

## equals

## should be TRUE
equals(FCSobj1, FCSobj2, check.filename=TRUE, check.objectname=TRUE)

## default does not check filename or objectname equality
## should be FALSE
equals(foo.FCSobj, dummy.FCSobj)

## fixvars
foo.FCSobj<-fixvars(foo.FCSobj)
## fluors
data.mat<-fluors(foo.FCSobj)
## metaData
metadata.ls<-metaData(foo.FCSobj)
## plot
## not interesting to plot dummy data

## default plot is pairs.CSP <pairs plot with Contour-images>
## plot(foo.FCSobj)

## can do joint image.parallel.coordinates pairs plots
## plot(foo.FCSobj, image.parallel.plot=TRUE)

## can do marginal image parallel coordinates pairs plots
## plot(foo.FCSobj, image.parallel.plot=TRUE, joint=FALSE)

## print
print(foo.FCSobj)
foo.FCSobj

## show
show(foo.FCSobj)

## summary
summary(foo.FCSobj)
summary(dummy.FCSobj)



