### Name: plot
### Title: Method plot for objects defined in this package
### Aliases: plot.maigesRaw plot.maiges plot.maigesANOVA plot.maigesDE
###   plot.maigesDEcluster plot.maigesClass plot.maigesRelNetB
###   plot.maigesRelNetM plot.maigesActMod plot.maigesActNet plot
### Keywords: array

### ** Examples

## Loading the dataset
data(gastro)

## Example with an object of class maigesRaw, without and with backgound
## subtraction, also we present a plot with normexp (from limma package)
## subtract algorithm.
plot(gastro.raw[,1], bkgSub="none")
plot(gastro.raw[,1], bkgSub="subtract")
plot(gastro.raw[,1], bkgSub="normexp")

## Example with an object of class maigesNorm.
plot(gastro.norm[,1])


## Example for objects of class maigesDE.

## Doing bootstrap from t statistic test fot 'Type' sample label, k=1000
## specifies one thousand bootstraps
gastro.ttest = deGenes2by2Ttest(gastro.summ, sLabelID="Type")

plot(gastro.ttest) ## Volcano plot

## Example for object of class maigesClass.

## Doing LDA classifier with 3 genes for the 6th gene group comparing
## the 2 categories from 'Type' sample label.
gastro.class = classifyLDA(gastro.summ, sLabelID="Type",
  gNameID="GeneName", nGenes=3, geneGrp=6)

plot(gastro.class) ## plot the 1st classifier
plot(gastro.class, idx=7) ## plot the 7th classifier


## Example for object of class maigesActNet

## Doing functional classification of gene groups for 'Tissue' sample label
gastro.mod = activeMod(gastro.summ, sLabelID="Tissue", cutExp=1,
  cutPhiper=0.05)

plot(gastro.mod, "S", margins=c(15,3)) ## Plot for individual samples
plot(gastro.mod, "C", margins=c(21,5)) ## Plot for unique biological conditions


## Example for object of class maigesRelNetB

## Constructing the relevance network (Butte's method) for sample
## 'Tissue' equal to 'Neso' for the 1st gene group
gastro.net = relNetworkB(gastro.summ, sLabelID="Tissue", 
  samples="Neso", geneGrp=1, type="Rpearson")

plot(gastro.net, cutPval=0.05)



## Example for object of class maigesRelNetM

## Constructing the relevance network for sample
## 'Tissue' comparing 'Neso' and 'Aeso' for the 1st gene group
gastro.net = relNetworkM(gastro.summ, sLabelID="Tissue", 
  samples = list(Neso="Neso", Aeso="Aeso"), geneGrp=11,
  type="Rpearson")

plot(gastro.net, cutPval=0.05)
plot(gastro.net, cutPval=0.01)


## Example for objects of class maigesActNet

## Doing functional classification of gene networks for sample Label
## given by 'Tissue'
gastro.net = activeNet(gastro.summ, sLabelID="Tissue")

plot(gastro.net, type="score", margins=c(21,5))
plot(gastro.net, type="p-value", margins=c(21,5))



